/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.Utils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetUnfilteredPartitionResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class GetUnfilteredPartitionRequest
implements SecretAgentRequest<GetUnfilteredPartitionResponse> {
    @NonNull
    private final long userId;
    @Nullable
    private final transient String catalogId;
    @NonNull
    private final String databaseName;
    @NonNull
    private final String tableName;
    @NonNull
    private final List<String> partitionValues;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(String.format("/v1/awsLakeFormation/getUnfilteredPartition/%s/%s/%s/%s", this.userId, StringUtils.isBlank(this.catalogId) ? "null" : Utils.extractAccountIdFromCatalogId(this.catalogId), this.databaseName, this.tableName));
        URIBuilder uriBuilder = new URIBuilder(baseUri).setPath(pathBuilder.toString());
        return uriBuilder.build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.GET;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<GetUnfilteredPartitionResponse> getResponseType() {
        return GetUnfilteredPartitionResponse.class;
    }

    GetUnfilteredPartitionRequest(@NonNull long userId, @Nullable String catalogId, @NonNull String databaseName, @NonNull String tableName, @NonNull List<String> partitionValues) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        if (partitionValues == null) {
            throw new NullPointerException("partitionValues is marked @NonNull but is null");
        }
        this.userId = userId;
        this.catalogId = catalogId;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.partitionValues = partitionValues;
    }

    public static GetUnfilteredPartitionRequestBuilder builder() {
        return new GetUnfilteredPartitionRequestBuilder();
    }

    @NonNull
    public long getUserId() {
        return this.userId;
    }

    @Nullable
    public String getCatalogId() {
        return this.catalogId;
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetUnfilteredPartitionRequest)) {
            return false;
        }
        GetUnfilteredPartitionRequest other = (GetUnfilteredPartitionRequest)o;
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<String> this$partitionValues = this.getPartitionValues();
        List<String> other$partitionValues = other.getPartitionValues();
        return !(this$partitionValues == null ? other$partitionValues != null : !((Object)this$partitionValues).equals(other$partitionValues));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $userId = this.getUserId();
        result = result * 59 + (int)($userId >>> 32 ^ $userId);
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<String> $partitionValues = this.getPartitionValues();
        result = result * 59 + ($partitionValues == null ? 43 : ((Object)$partitionValues).hashCode());
        return result;
    }

    public String toString() {
        return "GetUnfilteredPartitionRequest(userId=" + this.getUserId() + ", catalogId=" + this.getCatalogId() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", partitionValues=" + this.getPartitionValues() + ")";
    }

    public static class GetUnfilteredPartitionRequestBuilder {
        private long userId;
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<String> partitionValues;

        GetUnfilteredPartitionRequestBuilder() {
        }

        public GetUnfilteredPartitionRequestBuilder userId(@NonNull long userId) {
            this.userId = userId;
            return this;
        }

        public GetUnfilteredPartitionRequestBuilder catalogId(@Nullable String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public GetUnfilteredPartitionRequestBuilder databaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked @NonNull but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public GetUnfilteredPartitionRequestBuilder tableName(@NonNull String tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked @NonNull but is null");
            }
            this.tableName = tableName;
            return this;
        }

        public GetUnfilteredPartitionRequestBuilder partitionValues(@NonNull List<String> partitionValues) {
            if (partitionValues == null) {
                throw new NullPointerException("partitionValues is marked @NonNull but is null");
            }
            this.partitionValues = partitionValues;
            return this;
        }

        public GetUnfilteredPartitionRequest build() {
            return new GetUnfilteredPartitionRequest(this.userId, this.catalogId, this.databaseName, this.tableName, this.partitionValues);
        }

        public String toString() {
            return "GetUnfilteredPartitionRequest.GetUnfilteredPartitionRequestBuilder(userId=" + this.userId + ", catalogId=" + this.catalogId + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", partitionValues=" + this.partitionValues + ")";
        }
    }
}

