/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.Utils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class GetTemporaryCredentialsForTableRequest
implements SecretAgentRequest<TemporaryCredentials> {
    @NonNull
    private final transient long userId;
    @Nullable
    private final transient String catalogId;
    @NonNull
    private final transient String databaseName;
    @NonNull
    private final transient String name;
    @NonNull
    private final List<String> privilegeFilters;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        String path = String.format("/v1/awsLakeFormation/getTemporaryCredentialsForTable/%s/%s/%s/%s", this.userId, StringUtils.isBlank(this.catalogId) ? "null" : Utils.extractAccountIdFromCatalogId(this.catalogId), this.databaseName, this.name);
        return new URIBuilder(baseUri).setPath(path).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.GET;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<TemporaryCredentials> getResponseType() {
        return TemporaryCredentials.class;
    }

    GetTemporaryCredentialsForTableRequest(@NonNull long userId, @Nullable String catalogId, @NonNull String databaseName, @NonNull String name, @NonNull List<String> privilegeFilters) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked @NonNull but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (privilegeFilters == null) {
            throw new NullPointerException("privilegeFilters is marked @NonNull but is null");
        }
        this.userId = userId;
        this.catalogId = catalogId;
        this.databaseName = databaseName;
        this.name = name;
        this.privilegeFilters = privilegeFilters;
    }

    public static GetTemporaryCredentialsForTableRequestBuilder builder() {
        return new GetTemporaryCredentialsForTableRequestBuilder();
    }

    @NonNull
    public long getUserId() {
        return this.userId;
    }

    @Nullable
    public String getCatalogId() {
        return this.catalogId;
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public List<String> getPrivilegeFilters() {
        return this.privilegeFilters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetTemporaryCredentialsForTableRequest)) {
            return false;
        }
        GetTemporaryCredentialsForTableRequest other = (GetTemporaryCredentialsForTableRequest)o;
        List<String> this$privilegeFilters = this.getPrivilegeFilters();
        List<String> other$privilegeFilters = other.getPrivilegeFilters();
        return !(this$privilegeFilters == null ? other$privilegeFilters != null : !((Object)this$privilegeFilters).equals(other$privilegeFilters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $privilegeFilters = this.getPrivilegeFilters();
        result = result * 59 + ($privilegeFilters == null ? 43 : ((Object)$privilegeFilters).hashCode());
        return result;
    }

    public String toString() {
        return "GetTemporaryCredentialsForTableRequest(userId=" + this.getUserId() + ", catalogId=" + this.getCatalogId() + ", databaseName=" + this.getDatabaseName() + ", name=" + this.getName() + ", privilegeFilters=" + this.getPrivilegeFilters() + ")";
    }

    public static class GetTemporaryCredentialsForTableRequestBuilder {
        private long userId;
        private String catalogId;
        private String databaseName;
        private String name;
        private List<String> privilegeFilters;

        GetTemporaryCredentialsForTableRequestBuilder() {
        }

        public GetTemporaryCredentialsForTableRequestBuilder userId(@NonNull long userId) {
            this.userId = userId;
            return this;
        }

        public GetTemporaryCredentialsForTableRequestBuilder catalogId(@Nullable String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public GetTemporaryCredentialsForTableRequestBuilder databaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked @NonNull but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public GetTemporaryCredentialsForTableRequestBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            return this;
        }

        public GetTemporaryCredentialsForTableRequestBuilder privilegeFilters(@NonNull List<String> privilegeFilters) {
            if (privilegeFilters == null) {
                throw new NullPointerException("privilegeFilters is marked @NonNull but is null");
            }
            this.privilegeFilters = privilegeFilters;
            return this;
        }

        public GetTemporaryCredentialsForTableRequest build() {
            return new GetTemporaryCredentialsForTableRequest(this.userId, this.catalogId, this.databaseName, this.name, this.privilegeFilters);
        }

        public String toString() {
            return "GetTemporaryCredentialsForTableRequest.GetTemporaryCredentialsForTableRequestBuilder(userId=" + this.userId + ", catalogId=" + this.catalogId + ", databaseName=" + this.databaseName + ", name=" + this.name + ", privilegeFilters=" + this.privilegeFilters + ")";
        }
    }
}

