/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.ResourcePrivileges;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class GetTemporaryCredentialsForResourcesRequest
implements SecretAgentRequest<TemporaryCredentials> {
    @Nullable
    private final transient Long userId;
    @Nullable
    private final transient String username;
    @NonNull
    private final List<ResourcePrivileges> resourcePrivileges;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        String userIdentifier = this.username;
        if (userIdentifier == null && this.userId != null) {
            userIdentifier = Long.toString(this.userId);
        }
        String path = String.format("/v1/awsLakeFormation/getTemporaryCredentialsForTable/resourceArn/multiple%s", userIdentifier == null ? "" : "/user/" + userIdentifier);
        return new URIBuilder(baseUri).setPath(path).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.GET;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<TemporaryCredentials> getResponseType() {
        return TemporaryCredentials.class;
    }

    GetTemporaryCredentialsForResourcesRequest(@Nullable Long userId, @Nullable String username, @NonNull List<ResourcePrivileges> resourcePrivileges) {
        if (resourcePrivileges == null) {
            throw new NullPointerException("resourcePrivileges is marked @NonNull but is null");
        }
        this.userId = userId;
        this.username = username;
        this.resourcePrivileges = resourcePrivileges;
    }

    public static GetTemporaryCredentialsForResourcesRequestBuilder builder() {
        return new GetTemporaryCredentialsForResourcesRequestBuilder();
    }

    public GetTemporaryCredentialsForResourcesRequestBuilder toBuilder() {
        return new GetTemporaryCredentialsForResourcesRequestBuilder().userId(this.userId).username(this.username).resourcePrivileges(this.resourcePrivileges);
    }

    @Nullable
    public Long getUserId() {
        return this.userId;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public List<ResourcePrivileges> getResourcePrivileges() {
        return this.resourcePrivileges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetTemporaryCredentialsForResourcesRequest)) {
            return false;
        }
        GetTemporaryCredentialsForResourcesRequest other = (GetTemporaryCredentialsForResourcesRequest)o;
        List<ResourcePrivileges> this$resourcePrivileges = this.getResourcePrivileges();
        List<ResourcePrivileges> other$resourcePrivileges = other.getResourcePrivileges();
        return !(this$resourcePrivileges == null ? other$resourcePrivileges != null : !((Object)this$resourcePrivileges).equals(other$resourcePrivileges));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ResourcePrivileges> $resourcePrivileges = this.getResourcePrivileges();
        result = result * 59 + ($resourcePrivileges == null ? 43 : ((Object)$resourcePrivileges).hashCode());
        return result;
    }

    public String toString() {
        return "GetTemporaryCredentialsForResourcesRequest(userId=" + this.getUserId() + ", username=" + this.getUsername() + ", resourcePrivileges=" + this.getResourcePrivileges() + ")";
    }

    public static class GetTemporaryCredentialsForResourcesRequestBuilder {
        private Long userId;
        private String username;
        private List<ResourcePrivileges> resourcePrivileges;

        GetTemporaryCredentialsForResourcesRequestBuilder() {
        }

        public GetTemporaryCredentialsForResourcesRequestBuilder userId(@Nullable Long userId) {
            this.userId = userId;
            return this;
        }

        public GetTemporaryCredentialsForResourcesRequestBuilder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public GetTemporaryCredentialsForResourcesRequestBuilder resourcePrivileges(@NonNull List<ResourcePrivileges> resourcePrivileges) {
            if (resourcePrivileges == null) {
                throw new NullPointerException("resourcePrivileges is marked @NonNull but is null");
            }
            this.resourcePrivileges = resourcePrivileges;
            return this;
        }

        public GetTemporaryCredentialsForResourcesRequest build() {
            return new GetTemporaryCredentialsForResourcesRequest(this.userId, this.username, this.resourcePrivileges);
        }

        public String toString() {
            return "GetTemporaryCredentialsForResourcesRequest.GetTemporaryCredentialsForResourcesRequestBuilder(userId=" + this.userId + ", username=" + this.username + ", resourcePrivileges=" + this.resourcePrivileges + ")";
        }
    }
}

