/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class GetTemporaryCredentialsForPartitionRequest
implements SecretAgentRequest<TemporaryCredentials> {
    @NonNull
    private final transient long userId;
    @Nullable
    private final transient String catalogId;
    @NonNull
    private final transient String databaseName;
    @NonNull
    private final transient String tableName;
    @NonNull
    private final List<String> partitionValues;
    @NonNull
    private final List<String> privilegeFilters;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        String path = String.format("/v1/awsLakeFormation/getTemporaryCredentialsForPartition/%s/%s/%s/%s", this.userId, StringUtils.isBlank(this.catalogId) ? "null" : this.catalogId, this.databaseName, this.tableName);
        return new URIBuilder(baseUri).setPath(path).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.GET;
    }

    @Override
    public boolean isPathOnly() {
        return false;
    }

    @Override
    public Class<TemporaryCredentials> getResponseType() {
        return TemporaryCredentials.class;
    }

    GetTemporaryCredentialsForPartitionRequest(@NonNull long userId, @Nullable String catalogId, @NonNull String databaseName, @NonNull String tableName, @NonNull List<String> partitionValues, @NonNull List<String> privilegeFilters) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        if (partitionValues == null) {
            throw new NullPointerException("partitionValues is marked @NonNull but is null");
        }
        if (privilegeFilters == null) {
            throw new NullPointerException("privilegeFilters is marked @NonNull but is null");
        }
        this.userId = userId;
        this.catalogId = catalogId;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.partitionValues = partitionValues;
        this.privilegeFilters = privilegeFilters;
    }

    public static GetTemporaryCredentialsForPartitionRequestBuilder builder() {
        return new GetTemporaryCredentialsForPartitionRequestBuilder();
    }

    @NonNull
    public long getUserId() {
        return this.userId;
    }

    @Nullable
    public String getCatalogId() {
        return this.catalogId;
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    @NonNull
    public List<String> getPrivilegeFilters() {
        return this.privilegeFilters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetTemporaryCredentialsForPartitionRequest)) {
            return false;
        }
        GetTemporaryCredentialsForPartitionRequest other = (GetTemporaryCredentialsForPartitionRequest)o;
        List<String> this$partitionValues = this.getPartitionValues();
        List<String> other$partitionValues = other.getPartitionValues();
        if (this$partitionValues == null ? other$partitionValues != null : !((Object)this$partitionValues).equals(other$partitionValues)) {
            return false;
        }
        List<String> this$privilegeFilters = this.getPrivilegeFilters();
        List<String> other$privilegeFilters = other.getPrivilegeFilters();
        return !(this$privilegeFilters == null ? other$privilegeFilters != null : !((Object)this$privilegeFilters).equals(other$privilegeFilters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $partitionValues = this.getPartitionValues();
        result = result * 59 + ($partitionValues == null ? 43 : ((Object)$partitionValues).hashCode());
        List<String> $privilegeFilters = this.getPrivilegeFilters();
        result = result * 59 + ($privilegeFilters == null ? 43 : ((Object)$privilegeFilters).hashCode());
        return result;
    }

    public String toString() {
        return "GetTemporaryCredentialsForPartitionRequest(userId=" + this.getUserId() + ", catalogId=" + this.getCatalogId() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", partitionValues=" + this.getPartitionValues() + ", privilegeFilters=" + this.getPrivilegeFilters() + ")";
    }

    public static class GetTemporaryCredentialsForPartitionRequestBuilder {
        private long userId;
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<String> partitionValues;
        private List<String> privilegeFilters;

        GetTemporaryCredentialsForPartitionRequestBuilder() {
        }

        public GetTemporaryCredentialsForPartitionRequestBuilder userId(@NonNull long userId) {
            this.userId = userId;
            return this;
        }

        public GetTemporaryCredentialsForPartitionRequestBuilder catalogId(@Nullable String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public GetTemporaryCredentialsForPartitionRequestBuilder databaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked @NonNull but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public GetTemporaryCredentialsForPartitionRequestBuilder tableName(@NonNull String tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked @NonNull but is null");
            }
            this.tableName = tableName;
            return this;
        }

        public GetTemporaryCredentialsForPartitionRequestBuilder partitionValues(@NonNull List<String> partitionValues) {
            if (partitionValues == null) {
                throw new NullPointerException("partitionValues is marked @NonNull but is null");
            }
            this.partitionValues = partitionValues;
            return this;
        }

        public GetTemporaryCredentialsForPartitionRequestBuilder privilegeFilters(@NonNull List<String> privilegeFilters) {
            if (privilegeFilters == null) {
                throw new NullPointerException("privilegeFilters is marked @NonNull but is null");
            }
            this.privilegeFilters = privilegeFilters;
            return this;
        }

        public GetTemporaryCredentialsForPartitionRequest build() {
            return new GetTemporaryCredentialsForPartitionRequest(this.userId, this.catalogId, this.databaseName, this.tableName, this.partitionValues, this.privilegeFilters);
        }

        public String toString() {
            return "GetTemporaryCredentialsForPartitionRequest.GetTemporaryCredentialsForPartitionRequestBuilder(userId=" + this.userId + ", catalogId=" + this.catalogId + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", partitionValues=" + this.partitionValues + ", privilegeFilters=" + this.privilegeFilters + ")";
        }
    }
}

