/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Secret;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import lombok.NonNull;

public class GetSecretRequest
implements SecretAgentRequest<Secret> {
    @NonNull
    private String secretName;
    @Nullable
    private String usernameThatCreatedSecret;
    @Nullable
    private String version;
    @Nullable
    private String requestingUser;

    @Override
    public URI getURI(URI baseUri) throws URISyntaxException {
        return new URIBuilder(baseUri).setPath(String.format("/v1/secrets/%s", this.secretName)).addParameter("usernameThatCreatedSecret", this.usernameThatCreatedSecret).addParameter("version", this.version).addParameter("requestingUser", this.requestingUser).build();
    }

    @Override
    public RequestExecutor.HttpVerb getHttpVerb() {
        return RequestExecutor.HttpVerb.GET;
    }

    @Override
    public boolean isPathOnly() {
        return true;
    }

    @Override
    public Class<Secret> getResponseType() {
        return Secret.class;
    }

    public static GetSecretRequestBuilder builder() {
        return new GetSecretRequestBuilder();
    }

    @NonNull
    public String getSecretName() {
        return this.secretName;
    }

    @Nullable
    public String getUsernameThatCreatedSecret() {
        return this.usernameThatCreatedSecret;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getRequestingUser() {
        return this.requestingUser;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetSecretRequest)) {
            return false;
        }
        GetSecretRequest other = (GetSecretRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$secretName = this.getSecretName();
        String other$secretName = other.getSecretName();
        if (this$secretName == null ? other$secretName != null : !this$secretName.equals(other$secretName)) {
            return false;
        }
        String this$usernameThatCreatedSecret = this.getUsernameThatCreatedSecret();
        String other$usernameThatCreatedSecret = other.getUsernameThatCreatedSecret();
        if (this$usernameThatCreatedSecret == null ? other$usernameThatCreatedSecret != null : !this$usernameThatCreatedSecret.equals(other$usernameThatCreatedSecret)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$requestingUser = this.getRequestingUser();
        String other$requestingUser = other.getRequestingUser();
        return !(this$requestingUser == null ? other$requestingUser != null : !this$requestingUser.equals(other$requestingUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetSecretRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $secretName = this.getSecretName();
        result = result * 59 + ($secretName == null ? 43 : $secretName.hashCode());
        String $usernameThatCreatedSecret = this.getUsernameThatCreatedSecret();
        result = result * 59 + ($usernameThatCreatedSecret == null ? 43 : $usernameThatCreatedSecret.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $requestingUser = this.getRequestingUser();
        result = result * 59 + ($requestingUser == null ? 43 : $requestingUser.hashCode());
        return result;
    }

    public GetSecretRequest() {
    }

    public GetSecretRequest(@NonNull String secretName, @Nullable String usernameThatCreatedSecret, @Nullable String version, @Nullable String requestingUser) {
        if (secretName == null) {
            throw new NullPointerException("secretName is marked @NonNull but is null");
        }
        this.secretName = secretName;
        this.usernameThatCreatedSecret = usernameThatCreatedSecret;
        this.version = version;
        this.requestingUser = requestingUser;
    }

    public String toString() {
        return "GetSecretRequest(secretName=" + this.getSecretName() + ", usernameThatCreatedSecret=" + this.getUsernameThatCreatedSecret() + ", version=" + this.getVersion() + ", requestingUser=" + this.getRequestingUser() + ")";
    }

    public static class GetSecretRequestBuilder {
        private String secretName;
        private String usernameThatCreatedSecret;
        private String version;
        private String requestingUser;

        GetSecretRequestBuilder() {
        }

        public GetSecretRequestBuilder secretName(@NonNull String secretName) {
            if (secretName == null) {
                throw new NullPointerException("secretName is marked @NonNull but is null");
            }
            this.secretName = secretName;
            return this;
        }

        public GetSecretRequestBuilder usernameThatCreatedSecret(@Nullable String usernameThatCreatedSecret) {
            this.usernameThatCreatedSecret = usernameThatCreatedSecret;
            return this;
        }

        public GetSecretRequestBuilder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public GetSecretRequestBuilder requestingUser(@Nullable String requestingUser) {
            this.requestingUser = requestingUser;
            return this;
        }

        public GetSecretRequest build() {
            return new GetSecretRequest(this.secretName, this.usernameThatCreatedSecret, this.version, this.requestingUser);
        }

        public String toString() {
            return "GetSecretRequest.GetSecretRequestBuilder(secretName=" + this.secretName + ", usernameThatCreatedSecret=" + this.usernameThatCreatedSecret + ", version=" + this.version + ", requestingUser=" + this.requestingUser + ")";
        }
    }
}

