/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter.GsonFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.Gson;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonElement;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonObject;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParser;

public class Envelope<T> {
    private static final Gson GSON = GsonFactory.createGson();
    @JsonIgnore
    private transient int httpStatus;
    private String message;
    private T contents;

    public Envelope(String json, Class<T> contentsClass, int httpStatus) {
        this.httpStatus = httpStatus;
        try {
            JsonElement root = new JsonParser().parse(json);
            if (!root.isJsonObject()) {
                throw new JsonParseException("Root is not a JSON object");
            }
            JsonObject rootObject = root.getAsJsonObject();
            JsonElement messageElement = rootObject.get("message");
            if (messageElement == null || !messageElement.isJsonPrimitive()) {
                throw new JsonParseException("message not a primitive");
            }
            this.message = messageElement.getAsString();
            JsonElement contentsElement = rootObject.get("contents");
            this.contents = contentsElement == null ? null : GSON.fromJson(contentsElement, contentsClass);
        }
        catch (ClassCastException | IllegalStateException e) {
            throw new JsonParseException("Type mismatch", e);
        }
    }

    public String asJson() {
        return GSON.toJson(this);
    }

    @JsonIgnore
    public int getHttpStatus() {
        return this.httpStatus;
    }

    @JsonIgnore
    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public static <T> EnvelopeBuilder<T> builder() {
        return new EnvelopeBuilder();
    }

    public Envelope(int httpStatus, String message, T contents) {
        this.httpStatus = httpStatus;
        this.message = message;
        this.contents = contents;
    }

    public Envelope() {
    }

    public String getMessage() {
        return this.message;
    }

    public T getContents() {
        return this.contents;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setContents(T contents) {
        this.contents = contents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$contents = this.getContents();
        T other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !this$contents.equals(other$contents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Envelope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : $contents.hashCode());
        return result;
    }

    public String toString() {
        return "Envelope(httpStatus=" + this.getHttpStatus() + ", message=" + this.getMessage() + ", contents=" + this.getContents() + ")";
    }

    public static class EnvelopeBuilder<T> {
        private int httpStatus;
        private String message;
        private T contents;

        EnvelopeBuilder() {
        }

        public EnvelopeBuilder<T> httpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public EnvelopeBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public EnvelopeBuilder<T> contents(T contents) {
            this.contents = contents;
            return this;
        }

        public Envelope<T> build() {
            return new Envelope<T>(this.httpStatus, this.message, this.contents);
        }

        public String toString() {
            return "Envelope.EnvelopeBuilder(httpStatus=" + this.httpStatus + ", message=" + this.message + ", contents=" + this.contents + ")";
        }
    }
}

