/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter.GsonFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Envelope;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.Gson;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.HttpEntity;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.HttpResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.ParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.HttpClient;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpDelete;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpGet;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpPost;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpPut;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpUriRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.utils.URIBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.entity.StringEntity;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;

public class HttpRequestExecutor
implements RequestExecutor {
    private static final Gson GSON = GsonFactory.createGson();
    private final URI serverURI;
    private final HttpClient httpClient;

    public HttpRequestExecutor(URI serverURI, HttpClient httpClient) {
        this.serverURI = serverURI;
        this.httpClient = httpClient;
    }

    @Override
    public <T> Envelope<T> executeRequest(SecretAgentRequest<T> secretAgentRequest) {
        URI fullUri = null;
        try {
            fullUri = secretAgentRequest.getURI(this.serverURI);
            URI finalUri = this.serializeToUriIfGetting(secretAgentRequest, fullUri);
            HttpUriRequest request = this.requestForVerb(secretAgentRequest, finalUri);
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Accept", "application/json");
            HttpResponse httpResponse = this.httpClient.execute(request);
            return this.parseAndHandlerrors(secretAgentRequest.getResponseType(), httpResponse, fullUri);
        }
        catch (URISyntaxException e) {
            throw new SecretAgentClientException("Failed to construct request URI: serverUri=" + this.serverURI + "fullUri=" + fullUri, e);
        }
        catch (IOException e) {
            throw new SecretAgentClientException("Request failed at network level fullUri=" + fullUri, e);
        }
    }

    @VisibleForTesting
    protected <T> Envelope<T> parseAndHandlerrors(Class<T> responseType, HttpResponse httpResponse, URI uriForLog) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        try {
            String body = this.entityToString(httpResponse.getEntity());
            return new Envelope<T>(body, responseType, httpResponse.getStatusLine().getStatusCode());
        }
        catch (ParseException e) {
            throw new SecretAgentClientException("Apache Http Client could not parse the body of the response uri=" + uriForLog, e, statusCode);
        }
        catch (JsonParseException | ClassCastException | IllegalStateException e) {
            throw new SecretAgentClientException("GSON could not map response to Java type uri=" + uriForLog, e, statusCode);
        }
        catch (IOException e) {
            throw new SecretAgentClientException("Request failed at network level reading response uri=" + uriForLog, e, statusCode);
        }
    }

    @VisibleForTesting
    protected String entityToString(HttpEntity httpEntity) throws IOException {
        return EntityUtils.toString(httpEntity, "UTF-8");
    }

    private HttpUriRequest requestForVerb(SecretAgentRequest secretAgentRequest, URI uri) throws UnsupportedEncodingException {
        switch (secretAgentRequest.getHttpVerb()) {
            case GET: {
                return new HttpGet(uri);
            }
            case POST: {
                HttpPost httpPost = new HttpPost(uri);
                if (!secretAgentRequest.isPathOnly()) {
                    httpPost.setEntity(new StringEntity(GSON.toJson(secretAgentRequest)));
                }
                return httpPost;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(uri);
                if (!secretAgentRequest.isPathOnly()) {
                    httpPut.setEntity(new StringEntity(GSON.toJson(secretAgentRequest)));
                }
                return httpPut;
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
        }
        throw new IllegalArgumentException("Unrecognized verb: " + (Object)((Object)secretAgentRequest.getHttpVerb()));
    }

    private URI serializeToUriIfGetting(SecretAgentRequest secretAgentRequest, URI uri) throws URISyntaxException {
        boolean isPathOnly = secretAgentRequest.isPathOnly();
        RequestExecutor.HttpVerb httpVerb = secretAgentRequest.getHttpVerb();
        if (!isPathOnly && (RequestExecutor.HttpVerb.GET.equals((Object)httpVerb) || RequestExecutor.HttpVerb.DELETE.equals((Object)httpVerb))) {
            return new URIBuilder(uri).addParameter("json", GSON.toJson(secretAgentRequest)).build();
        }
        return uri;
    }
}

