/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.algorithms;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.SecretAgentClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetOrGenerateSecretKeyException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetOrGenerateSecretRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetSecretRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Secret;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.StoreSecretRequest;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TreeSet;

public class GetOrGenerateSecretAlgorithm {
    private static final int DEFAULT_MAX_SLEEP_INTERVAL_MILLIS = 1000;
    private final Random random = new Random();
    private final SecretAgentClient secretAgentClient;
    private final int maxSleepIntervalMillis;

    public GetOrGenerateSecretAlgorithm(SecretAgentClient secretAgentClient) {
        this(secretAgentClient, 1000);
    }

    public GetOrGenerateSecretAlgorithm(SecretAgentClient secretAgentClient, int maxSleepIntervalMillis) {
        this.secretAgentClient = secretAgentClient;
        this.maxSleepIntervalMillis = maxSleepIntervalMillis;
    }

    public Secret getOrGenerateSecret(GetOrGenerateSecretRequest request) {
        this.validateRequest(request);
        try {
            Optional<Secret> existing = this.checkForValidLatestSecret(request);
            if (existing.isPresent()) {
                return existing.get();
            }
            this.sleep();
            return this.createSecretIfItDoesNotExit(request);
        }
        catch (GetOrGenerateSecretKeyException e) {
            throw e;
        }
        catch (SecretAgentClientException e) {
            throw new GetOrGenerateSecretKeyException("Secret Agent client failure creating " + request.getSecretName(), e);
        }
        catch (InterruptedException e) {
            throw new GetOrGenerateSecretKeyException("Interrupted sleeping while creating " + request.getSecretName());
        }
    }

    private void validateRequest(GetOrGenerateSecretRequest request) {
        if (request.getProposedSecretValue() == null) {
            throw new GetOrGenerateSecretKeyException("Proposed secret cannot be null");
        }
        if (request.getUsernameThatCreatedSecret() == null) {
            throw new GetOrGenerateSecretKeyException("Username that created secret cannot be null");
        }
    }

    private Secret createSecretIfItDoesNotExit(GetOrGenerateSecretRequest request) {
        Optional<Secret> existing = this.checkForValidLatestSecret(request);
        if (existing.isPresent()) {
            return existing.get();
        }
        List<String> accessUsers = this.addOurselvesToUserList(request.getUsernameThatCreatedSecret(), request.getProposedSecretValue().getAccessUsers());
        List<String> adminUsers = this.addOurselvesToUserList(request.getUsernameThatCreatedSecret(), request.getProposedSecretValue().getAdminUsers());
        Secret secretWithAccessUsers = request.getProposedSecretValue().toBuilder().accessUsers(accessUsers).adminUsers(adminUsers).build();
        StoreSecretRequest storeSecretRequest = StoreSecretRequest.builder().enableUserAuthenticatedNamespaces(true).versioned(true).usernameThatCreatedSecret(request.getUsernameThatCreatedSecret()).secret(secretWithAccessUsers).build();
        Optional<String> version = this.secretAgentClient.storeVersionedSecret(storeSecretRequest);
        if (version == null) {
            throw new GetOrGenerateSecretKeyException("Server sent a null response secretName=" + request.getSecretName());
        }
        if (!version.isPresent()) {
            throw new GetOrGenerateSecretKeyException("Server did not set a version! Is it running old code? secretName=" + request.getSecretName());
        }
        return request.getProposedSecretValue().toBuilder().version(version.get()).build();
    }

    private void sleep() throws InterruptedException {
        int sleepInterval = this.random.nextInt(this.maxSleepIntervalMillis);
        Thread.sleep(sleepInterval);
    }

    private List<String> addOurselvesToUserList(String ourselves, List<String> users) {
        TreeSet<String> set = new TreeSet<String>();
        if (users != null && !users.isEmpty()) {
            set.addAll(users);
        }
        set.add(ourselves);
        return new ArrayList<String>(set);
    }

    private Optional<Secret> checkForValidLatestSecret(GetOrGenerateSecretRequest request) {
        Optional<Secret> existing = this.secretAgentClient.getSecret(GetSecretRequest.builder().secretName(request.getSecretName()).usernameThatCreatedSecret(request.getUsernameThatCreatedSecret()).version(null).build());
        if (this.isLatestSecretValid(existing, request.getDurationUntilPriorSecretExpiresToCreateNewVersion())) {
            return existing;
        }
        return Optional.empty();
    }

    private boolean isLatestSecretValid(Optional<Secret> secretOptional, Duration durationUntilPriorSecretExpiresToCreateNewVersion) {
        if (!secretOptional.isPresent()) {
            return false;
        }
        Secret secret = secretOptional.get();
        if (secret.getExpirationDateTime() == null) {
            return true;
        }
        if (durationUntilPriorSecretExpiresToCreateNewVersion == null) {
            return secret.getExpirationDateTime().compareTo(ZonedDateTime.now()) >= 0;
        }
        return secret.getExpirationDateTime().compareTo(ZonedDateTime.now().plus(durationUntilPriorSecretExpiresToCreateNewVersion)) >= 0;
    }
}

