/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Secret;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonArray;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonDeserializationContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonDeserializer;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonElement;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonObject;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.codec.binary.Base64;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SecretGsonDeserializer
implements JsonDeserializer<Secret> {
    @Override
    public Secret deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("root not object");
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.checkField(jsonObject, "secretBytes");
        this.checkField(jsonObject, "name");
        this.checkField(jsonObject, "accessUsers");
        this.checkField(jsonObject, "adminUsers");
        try {
            byte[] secretBytes = null;
            JsonElement secretElement = jsonObject.get("secretBytes");
            if (secretElement.isJsonArray()) {
                secretBytes = this.convertToByte(secretElement.getAsJsonArray());
            } else {
                String base64Secret = jsonObject.get("secretBytes").getAsString();
                secretBytes = Base64.decodeBase64(base64Secret);
            }
            Secret.SecretBuilder builder = Secret.builder().name(jsonObject.get("name").getAsString()).accessUsers(this.convertToString(jsonObject.get("accessUsers").getAsJsonArray())).adminUsers(this.convertToString(jsonObject.get("adminUsers").getAsJsonArray())).secretBytes(secretBytes);
            JsonElement expiration = jsonObject.get("expirationDateTime");
            if (expiration != null && !expiration.isJsonNull()) {
                builder.expirationDateTime(ZonedDateTime.parse(jsonObject.get("expirationDateTime").getAsString()));
            }
            return builder.build();
        }
        catch (ClassCastException | IllegalStateException e) {
            throw new JsonParseException("Wrong type for field", e);
        }
    }

    private List<String> convertToString(JsonArray array) {
        ArrayList<String> result = new ArrayList<String>(array.size());
        Iterator<JsonElement> iter = array.iterator();
        while (iter.hasNext()) {
            result.add(iter.next().getAsString());
        }
        return result;
    }

    private byte[] convertToByte(JsonArray array) {
        byte[] result = new byte[array.size()];
        Iterator<JsonElement> iterator = array.iterator();
        int idx = 0;
        while (iterator.hasNext()) {
            result[idx] = iterator.next().getAsByte();
            ++idx;
        }
        return result;
    }

    private void checkField(JsonObject jsonObject, String field) {
        if (jsonObject.get(field) == null) {
            throw new JsonParseException("Missing field: " + field);
        }
    }
}

