/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.adapter;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonDeserializationContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonDeserializer;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonElement;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonPrimitive;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonSerializationContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    @Override
    public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!jsonElement.isJsonPrimitive()) {
            throw new JsonParseException("Date must be a primitive!");
        }
        JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
        if (primitive.isNumber()) {
            return new Date(jsonElement.getAsLong());
        }
        if (primitive.isString()) {
            String inputString = primitive.getAsString();
            try {
                if (inputString.isEmpty()) {
                    throw new JsonParseException("Date must not be empty string");
                }
                if (Character.isDigit(inputString.charAt(0))) {
                    SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
                    iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
                    return iso8601.parse(inputString);
                }
                SimpleDateFormat gsonDefault = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS aa");
                gsonDefault.setTimeZone(TimeZone.getTimeZone("UTC"));
                return gsonDefault.parse(inputString);
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
        throw new JsonParseException("Date must be a number or string");
    }

    @Override
    public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(date.getTime());
    }
}

