/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.SecretAgentClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.algorithms.GetOrGenerateSecretAlgorithm;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.HttpRequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.executor.RequestExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Envelope;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetOrGenerateSecretKeyException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetOrGenerateSecretRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetOrGenerateSecretResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetSecretRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetTemporaryCredentialsForMetadataRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetTemporaryCredentialsForPartitionRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetTemporaryCredentialsForResourcesRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetTemporaryCredentialsForTableRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetUnfilteredPartitionRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetUnfilteredPartitionResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetUnfilteredTableRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetUnfilteredTableResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.PingRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.Secret;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.StoreSecretRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.StoreUserCredentialRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.StoreUserCredentialResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.UpdateSecretRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.UpdateSecretResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.HttpClient;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.impl.client.HttpClientBuilder;
import java.net.URI;
import java.util.Optional;

class SecretAgentClientImpl
implements SecretAgentClient {
    private final RequestExecutor requestExecutor;

    public SecretAgentClientImpl(URI serverUri) {
        this.requestExecutor = new HttpRequestExecutor(serverUri, HttpClientBuilder.create().build());
    }

    public SecretAgentClientImpl(URI serverUri, HttpClient httpClient) {
        this.requestExecutor = new HttpRequestExecutor(serverUri, httpClient);
    }

    @VisibleForTesting
    SecretAgentClientImpl(RequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    @Override
    public Optional<Secret> getSecret(GetSecretRequest getSecretRequest) {
        return this.executeOptionalRequestThrowIfNotOk(getSecretRequest);
    }

    @Override
    public void storeSecret(StoreSecretRequest storeSecretRequest) {
        this.executeRequestThrowIfNotOk(storeSecretRequest);
    }

    @Override
    public Optional<String> storeVersionedSecret(StoreSecretRequest storeSecretRequest) {
        return Optional.of(this.executeRequestThrowIfNotOk(storeSecretRequest).getVersion());
    }

    @Override
    public boolean updateSecret(UpdateSecretRequest updateSecretRequest) {
        Optional<UpdateSecretResponse> response = this.executeOptionalRequestThrowIfNotOk(updateSecretRequest);
        return response.isPresent();
    }

    @Override
    public Optional<TemporaryCredentials> getTemporaryCredentialsForTable(GetTemporaryCredentialsForTableRequest getTemporaryCredentialsForTableRequest) {
        return this.executeOptionalRequestThrowIfNotOk(getTemporaryCredentialsForTableRequest);
    }

    @Override
    public Optional<TemporaryCredentials> getTemporaryCredentialsForResources(GetTemporaryCredentialsForResourcesRequest getTemporaryCredentialsForResourcesRequest) {
        return this.executeOptionalRequestThrowIfNotOk(getTemporaryCredentialsForResourcesRequest);
    }

    @Override
    public Optional<TemporaryCredentials> getTemporaryCredentialsForPartition(GetTemporaryCredentialsForPartitionRequest getTemporaryCredentialsForPartitionRequest) {
        return this.executeOptionalRequestThrowIfNotOk(getTemporaryCredentialsForPartitionRequest);
    }

    @Override
    public Optional<TemporaryCredentials> getTemporaryCredentialsForMetadata() {
        return this.executeOptionalRequestThrowIfNotOk(GetTemporaryCredentialsForMetadataRequest.builder().build());
    }

    @Override
    public Optional<TemporaryCredentials> getTemporaryCredentialsForMetadata(GetTemporaryCredentialsForMetadataRequest request) {
        return this.executeOptionalRequestThrowIfNotOk(request);
    }

    @Override
    public Optional<GetUnfilteredTableResponse> getUnfilteredTable(GetUnfilteredTableRequest getUnfilteredTableRequest) {
        return this.executeOptionalRequestThrowIfNotOk(getUnfilteredTableRequest);
    }

    @Override
    public Optional<GetUnfilteredPartitionResponse> getUnfilteredPartition(GetUnfilteredPartitionRequest getUnfilteredPartitionRequest) {
        return this.executeOptionalRequestThrowIfNotOk(getUnfilteredPartitionRequest);
    }

    @Override
    public void storeUserCredential(StoreUserCredentialRequest storeUserCredentialRequest) {
        this.executeRequestThrowIfNotOk(storeUserCredentialRequest);
    }

    @Override
    public int storeUserCredentialReturnUserId(StoreUserCredentialRequest storeUserCredentialRequest) {
        StoreUserCredentialResponse response = this.executeRequestThrowIfNotOk(storeUserCredentialRequest);
        return response.getUserId();
    }

    @Override
    public void ping() {
        this.executeRequestThrowIfNotOk(new PingRequest());
    }

    @Override
    public GetOrGenerateSecretResponse getOrGenerateSecret(GetOrGenerateSecretRequest request) throws GetOrGenerateSecretKeyException {
        return GetOrGenerateSecretResponse.builder().secret(new GetOrGenerateSecretAlgorithm(this).getOrGenerateSecret(request)).build();
    }

    private boolean isNotFound(Envelope<?> response) {
        return response.getHttpStatus() == 404;
    }

    private boolean isOk(Envelope<?> response) {
        return response.getHttpStatus() == 200;
    }

    private void throwIfNotOk(Envelope<?> response) {
        if (!this.isOk(response)) {
            throw new SecretAgentClientException(response.getMessage(), response.getHttpStatus());
        }
    }

    private <R> R executeRequestThrowIfNotOk(SecretAgentRequest<R> secretAgentRequest) {
        Envelope<R> response = this.requestExecutor.executeRequest(secretAgentRequest);
        this.throwIfNotOk(response);
        return response.getContents();
    }

    private <R> Optional<R> executeOptionalRequestThrowIfNotOk(SecretAgentRequest<R> secretAgentRequest) {
        Envelope<R> response = this.requestExecutor.executeRequest(secretAgentRequest);
        if (this.isNotFound(response)) {
            return Optional.empty();
        }
        this.throwIfNotOk(response);
        return Optional.of(response.getContents());
    }
}

