/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.ContainerCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.Log;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.LogFactory;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;

public class EC2ContainerCredentialsProviderWrapper
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(EC2ContainerCredentialsProviderWrapper.class);
    private final AWSCredentialsProvider provider = this.initializeProvider();

    private AWSCredentialsProvider initializeProvider() {
        try {
            if (System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI") != null) {
                return new ContainerCredentialsProvider(new ContainerCredentialsProvider.ECSCredentialsEndpointProvider());
            }
            if (System.getenv("AWS_CONTAINER_CREDENTIALS_FULL_URI") != null) {
                return new ContainerCredentialsProvider(new ContainerCredentialsProvider.FullUriCredentialsEndpointProvider());
            }
            return InstanceProfileCredentialsProvider.getInstance();
        }
        catch (SecurityException securityException) {
            LOG.debug("Security manager did not allow access to the ECS credentials environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URIor the container full URI environment variable AWS_CONTAINER_CREDENTIALS_FULL_URI. Please provide access to this environment variable if you want to load credentials from ECS Container.");
            return InstanceProfileCredentialsProvider.getInstance();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.provider.getCredentials();
    }

    @Override
    public void refresh() {
        this.provider.refresh();
    }
}

