/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.secretagent;

import com.amazon.ws.emr.hadoop.fs.exception.AccessDeniedException;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Call;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.BasicSessionCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.policy.actions.S3Actions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.SecretAgentClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.GetTemporaryCredentialsForResourcesRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.ResourcePrivileges;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.SecretAgentClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretAgentS3CredentialsProvider
implements AWSSessionCredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(SecretAgentS3CredentialsProvider.class);
    static final int DEFAULT_SECONDS_BEFORE_EXPIRATION_TO_REFRESH_CREDENTIALS = 300;
    private final int secondsBeforeExpirationToRefreshCredentials;
    private final SecretAgentClient secretAgentClient;
    private final FileSystemOwner fileSystemOwner;
    private final S3Call s3Call;
    private AWSSessionCredentials sessionCredentials;
    private ZonedDateTime expiration;

    public SecretAgentS3CredentialsProvider(@NonNull SecretAgentClient secretAgentClient, @NonNull FileSystemOwner fileSystemOwner, @NonNull S3Call s3Call) {
        this(secretAgentClient, fileSystemOwner, s3Call, 300);
        if (secretAgentClient == null) {
            throw new NullPointerException("secretAgentClient is marked non-null but is null");
        }
        if (fileSystemOwner == null) {
            throw new NullPointerException("fileSystemOwner is marked non-null but is null");
        }
        if (s3Call == null) {
            throw new NullPointerException("s3Call is marked non-null but is null");
        }
    }

    @VisibleForTesting
    SecretAgentS3CredentialsProvider(SecretAgentClient secretAgentClient, FileSystemOwner fileSystemOwner, S3Call s3Call, int secondsBeforeExpirationToRefreshCredentials) {
        this.secretAgentClient = secretAgentClient;
        this.fileSystemOwner = fileSystemOwner;
        this.s3Call = s3Call;
        this.secondsBeforeExpirationToRefreshCredentials = secondsBeforeExpirationToRefreshCredentials;
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    private void startSession() {
        if (this.s3Call.getS3Resources().isEmpty()) {
            throw new IllegalArgumentException("No S3 resources found for the call: " + this.s3Call.getClass().getSimpleName());
        }
        S3Resource s3Resource = this.s3Call.getS3Resources().iterator().next();
        String s3Path = this.getS3Path(s3Resource);
        List<S3Actions> s3Actions = this.s3Call.getS3Actions();
        List<String> s3ActionNames = s3Actions.stream().map(Enum::name).collect(Collectors.toList());
        ArrayList<ResourcePrivileges> resourcePrivileges = Lists.newArrayList(ResourcePrivileges.builder().arn(s3Path).privilegeFilters(s3ActionNames).build());
        GetTemporaryCredentialsForResourcesRequest request = GetTemporaryCredentialsForResourcesRequest.builder().resourcePrivileges(resourcePrivileges).build();
        logger.debug("Retrieving credentials for s3 call: {} and request: {}", (Object)this.s3Call.getClass().getSimpleName(), (Object)request);
        try {
            TemporaryCredentials temporaryCredentials = this.secretAgentClient.getTemporaryCredentialsForResources(request).orElseThrow(() -> new AccessDeniedException("Secret Agent returned empty credentials for request: " + request.toString()));
            this.sessionCredentials = new BasicSessionCredentials(temporaryCredentials.getAwsAccessKeyId(), temporaryCredentials.getAwsSecretKey(), temporaryCredentials.getSessionToken());
            this.expiration = temporaryCredentials.getExpiration();
            logger.debug("Successfully retrieved credentials for {}", (Object)request);
        }
        catch (SecretAgentClientException sae) {
            throw new AccessDeniedException("Failed to retrieve credentials from secret agent for request: " + request.toString(), sae);
        }
    }

    private boolean needsNewSession() {
        return this.sessionCredentials == null || this.isCredentialsExpired();
    }

    private boolean isCredentialsExpired() {
        long timeRemaining = this.expiration.toInstant().toEpochMilli() - System.currentTimeMillis();
        return timeRemaining <= (long)(this.secondsBeforeExpirationToRefreshCredentials * 1000);
    }

    @VisibleForTesting
    String getS3Path(S3Resource s3Resource) {
        StringBuilder s3Path = new StringBuilder(s3Resource.getBucketName());
        if (s3Resource.getPath() != null) {
            if (s3Resource.getPath().startsWith("/")) {
                s3Path.append(s3Resource.getPath());
            } else {
                s3Path.append("/").append(s3Resource.getPath());
            }
        }
        return s3Path.toString();
    }
}

