/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n2;

import com.amazon.ws.emr.hadoop.fs.consistency.ConsistencyCheckerS3FileSystem;
import com.amazon.ws.emr.hadoop.fs.consistency.ConsistencyExceptionThrowableObjectMetadataRetrieverImpl;
import com.amazon.ws.emr.hadoop.fs.consistency.ConsistentExceptionRetryPolicy;
import com.amazon.ws.emr.hadoop.fs.consistency.exception.ConsistencyException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.maintenance.MultipartUploadCleaner;
import com.amazon.ws.emr.hadoop.fs.notification.NotificationDispatcher;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.s3.S3NativeCommonFileSystem;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.ConsistencyExceptionThrowableObjectMetadataRetriever;
import com.amazon.ws.emr.hadoop.fs.s3n2.S3FileSystem;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import com.amazon.ws.emr.hadoop.fs.util.io.MoreCloseables;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NativeFileSystem2
extends S3NativeCommonFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(S3NativeFileSystem2.class);
    private boolean initialized = false;
    private boolean throwOnInconsistency;
    private String bucket;
    private S3FileSystem s3FileSystem;
    @Inject
    private EntityStore<Entity> entityStore;
    @Inject
    private AmazonS3Lite s3;
    @Inject
    private ListeningExecutorService listeningExecutorService;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private MultipartUploadCleaner multipartUploadCleaner;
    @Inject
    private FileSystemOwner fileSystemOwner;

    public void close() throws IOException {
        logger.debug("Closing for bucket {}", (Object)this.bucket);
        logger.debug("Shutting down thread pool executor");
        Closeable[] closeableArray = new Closeable[2];
        closeableArray[0] = this.s3FileSystem;
        closeableArray[1] = this.listeningExecutorService::shutdown;
        MoreCloseables.closeAll(closeableArray);
        logger.debug("Done closing for bucket {}", (Object)this.bucket);
    }

    @Override
    public void initialize(URI uri, Configuration configuration) throws IOException {
        Preconditions.checkArgument(!this.initialized, "{} has already initialized", ((Object)((Object)this)).getClass().getName());
        this.initialized = true;
        super.initialize(uri, configuration);
        this.setConf(configuration);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        logger.debug("URI is {}", (Object)this.uri);
        this.bucket = S3UriUtils.pathToBucket(new Path(this.uri));
        this.setWorkingDirectory(new Path("/user", this.fileSystemOwner.getFullUserName()).makeQualified(uri, this.getWorkingDirectory()));
        this.s3FileSystem = this.createConsistencyCheckerFileSystem(configuration);
        logger.debug("Setting working directory to '{}'", (Object)this.getWorkingDirectory());
        this.ensureBucketExists();
        if (ConfigurationUtils.isServerSideEncryptionEnabled(configuration)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(configuration);
        }
        this.throwOnInconsistency = ConfigurationUtils.isThrowingExceptionOnInconsistencyEnabled(configuration);
        this.multipartUploadCleaner.scheduleMultipartCleanup(this.bucket);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.open(path, bufferSize, this.throwOnInconsistency, this.statistics);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Open, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            logger.warn(e.getMessage(), (Throwable)e);
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.create(path, overwrite, progress, this.statistics);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Create, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            throw new IOException("Cannot create file due to inconsistency: " + path, e);
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        logger.info("rename {} {}", (Object)src.toString(), (Object)dst.toString());
        this.checkNotStagingDirectoryPath(src);
        this.checkNotStagingDirectoryPath(dst);
        this.multipartUploadCleaner.scheduleMultipartCleanup(src);
        this.multipartUploadCleaner.scheduleMultipartCleanup(dst);
        try {
            return this.s3FileSystem.rename(src, dst, true);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Rename, src, dst, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            return this.s3FileSystem.rename(src, dst, false);
        }
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.delete(path, recursive, true);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Delete, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            return this.s3FileSystem.delete(path, recursive, false);
        }
    }

    public boolean deleteOnExit(Path path) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        return super.deleteOnExit(path);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            this.s3FileSystem.mkdirs(path);
            return true;
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Mkdirs, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            throw new IOException("Cannot create directory due to inconsistency: " + path, e);
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.listStatus(path, true);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.ListStatus, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            try {
                return this.s3FileSystem.listStatus(path, false);
            }
            catch (AmazonClientException ace) {
                throw new IOException(ace);
            }
        }
        catch (AmazonClientException ace) {
            throw new IOException(ace);
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.getFileStatus(path);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.GetFileStatus, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            logger.warn(e.getMessage(), (Throwable)e);
            throw new FileNotFoundException(e.getMessage());
        }
        catch (AmazonClientException ace) {
            throw new IOException(ace);
        }
    }

    @Override
    public long getDefaultBlockSize() {
        return super.getDefaultBlockSize();
    }

    public long getDefaultBlockSize(Path path) {
        return this.getDefaultBlockSize();
    }

    @Override
    public FSDataInputStream select(Path path, Configuration selectOptions, int bufferSize) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            return this.s3FileSystem.select(path, selectOptions, bufferSize, this.throwOnInconsistency, this.statistics);
        }
        catch (ConsistencyException e) {
            this.notificationDispatcher.inconsistency(Notifier.Api.Open, path, e.getInconsistentPaths());
            if (this.throwOnInconsistency) {
                throw e;
            }
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return this.s3FileSystem.getStagingDirectoryService();
    }

    private void ensureBucketExists() {
        if (ConfigurationUtils.isCreateBucketEnabled(this.getConf())) {
            logger.debug("Validating that bucket '{}' exists", (Object)this.bucket);
            String bucketsCreateRegion = ConfigurationUtils.getBucketsCreateRegion(this.getConf());
            if (!this.s3.doesBucketExist(this.bucket)) {
                this.s3.createBucket(this.bucket, bucketsCreateRegion);
            }
        }
    }

    private S3FileSystem createConsistencyCheckerFileSystem(Configuration configuration) {
        RetryPolicy retryPolicy = ConsistentExceptionRetryPolicy.createConsistentExceptionRetryPolicy(this.getConf());
        ConsistencyExceptionThrowableObjectMetadataRetriever objectMetadataRetriever = (ConsistencyExceptionThrowableObjectMetadataRetriever)RetryProxy.create(ConsistencyExceptionThrowableObjectMetadataRetriever.class, (Object)new ConsistencyExceptionThrowableObjectMetadataRetrieverImpl(this.s3), (RetryPolicy)retryPolicy);
        ConsistencyCheckerS3FileSystem fileSystem = new ConsistencyCheckerS3FileSystem(this.s3, this.entityStore, this.listeningExecutorService, configuration, this.getUri(), this.getWorkingDirectory(), arg_0 -> ((S3NativeFileSystem2)this).checkPath(arg_0), path -> this.delete((Path)path, true), this.getDefaultBlockSize(), this.fileSystemOwner, objectMetadataRetriever);
        return (S3FileSystem)RetryProxy.create(S3FileSystem.class, (Object)fileSystem, (RetryPolicy)retryPolicy);
    }
}

