/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.EmrFSFutureCallback;
import com.amazon.ws.emr.hadoop.fs.cse.CSEMultipartUploadOutputStream;
import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectories;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectoriesGenerator;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryFiles;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.list.ListOrderComparator;
import com.amazon.ws.emr.hadoop.fs.list.OnlyFilesOrderedListing;
import com.amazon.ws.emr.hadoop.fs.maintenance.MultipartUploadCleaner;
import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystem;
import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystemFactory;
import com.amazon.ws.emr.hadoop.fs.s3.S3NativeCommonFileSystem;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AfterUploadCompletionObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.PreviousInstructionFileDeleter;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UnencryptedLengthHeaderAdder;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.RegularUploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.BasicFileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusCache;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.Jets3tNativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.MultipartUploadOutputStream;
import com.amazon.ws.emr.hadoop.fs.s3n.NativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.PartialListing;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Sets;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.staging.StagingMechanism;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazon.ws.emr.hadoop.fs.util.ExceptionCollector;
import com.amazon.ws.emr.hadoop.fs.util.RemoteIterators;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.fs.list.OrderedListCapable;
import org.apache.hadoop.fs.list.OrderedListingBuilder;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3NativeFileSystem
extends S3NativeCommonFileSystem
implements OrderedListCapable {
    private static final Logger logger = LoggerFactory.getLogger(S3NativeFileSystem.class);
    private static ThreadLocal<FileStatusCache> cachedFileStatus = ThreadLocal.withInitial(() -> {
        logger.info("Creating cachedFileStatus initial object");
        return new FileStatusCache();
    });
    private static ThreadLocal<Boolean> useCache = ThreadLocal.withInitial(() -> false);
    protected NativeFileSystemStore store;
    private String serverSideEncryptionKmsKeyId = null;
    private FileStatusFactory fileStatusFactory;
    private FileCreationSubsystem fileCreationSubsystem;
    private Set<org.apache.hadoop.fs.Path> deleteOnExit = new TreeSet<org.apache.hadoop.fs.Path>();
    private TemporaryDirectoriesGenerator temporaryDirectoriesGenerator;
    private Comparator<org.apache.hadoop.fs.Path> listOrder;
    @Inject
    private ListeningExecutorService listeningExecutorService;
    @Inject
    private AmazonS3Lite s3;
    @Inject
    private FileSystemOwner fileSystemOwner;
    @Inject
    private MultipartUploadCleaner multipartUploadCleaner;

    @Inject
    public S3NativeFileSystem() {
    }

    public static synchronized void enableCache() {
        logger.info("Enable FileStatusCache for contiguous s3 objects");
        useCache.set(true);
    }

    public static synchronized void disableCache() {
        logger.info("Disabling FileStatusCache");
        useCache.set(false);
        S3NativeFileSystem.clearCache();
    }

    public static synchronized boolean isCacheEnabled() {
        return useCache.get();
    }

    public static void clearCache() {
        cachedFileStatus.get().clearCache();
    }

    private void clearCache(String key) {
        if (useCache.get().booleanValue()) {
            cachedFileStatus.get().clearKey(key);
        }
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.initializeSSE(conf);
        this.initializeCache(conf);
        if (this.store == null) {
            this.store = new Jets3tNativeFileSystemStore(this.s3, this.listeningExecutorService);
        }
        this.store.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDirectory = new org.apache.hadoop.fs.Path("/user", this.fileSystemOwner.getFullUserName()).makeQualified(this.getUri(), this.getWorkingDirectory());
        this.temporaryDirectoriesGenerator = new TemporaryDirectoriesGenerator(ConfigurationUtils.getTestedTempPaths(conf));
        this.multipartUploadCleaner.scheduleMultipartCleanup(uri);
        this.fileStatusFactory = this.newFileStatusFactory();
        this.fileCreationSubsystem = this.newFileCreationSubsystem(uri, conf);
        this.listOrder = new ListOrderComparator(arg_0 -> ((S3NativeFileSystem)this).checkPath(arg_0));
    }

    private void initializeSSE(Configuration conf) {
        if (ConfigurationUtils.isServerSideEncryptionEnabled(conf)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(conf);
            this.serverSideEncryptionKmsKeyId = ConfigurationUtils.getServerSideEncryptionKmsKeyId(conf);
        }
    }

    private void initializeCache(Configuration conf) {
        if (ConfigurationUtils.isFileStatusCacheEnabled(conf)) {
            S3NativeFileSystem.enableCache();
            S3NativeFileSystem.clearCache();
        }
    }

    private BasicFileStatusFactory newFileStatusFactory() {
        return BasicFileStatusFactory.builder().fileSystemOwner(this.fileSystemOwner).pathQualifier(arg_0 -> ((S3NativeFileSystem)this).makeQualified(arg_0)).blockSizeSupplier(this::getDefaultBlockSize).build();
    }

    private FileCreationSubsystem newFileCreationSubsystem(URI uri, Configuration conf) {
        FileCreationSubsystemFactory factory = FileCreationSubsystemFactory.builder().uri(uri).conf(conf).s3(this.s3).requestFactory(new S3ObjectRequestFactory(conf, this.serverSideEncryptionKmsKeyId)).uploadObserver(this.newUploadObserver()).nonStagingPlannerFactory(this.newNonStagingPlannerFactory()).pathQualifier(arg_0 -> ((S3NativeFileSystem)this).makeQualified(arg_0)).pathChecker(arg_0 -> ((S3NativeFileSystem)this).checkPath(arg_0)).pathDeleter(path -> this.delete((org.apache.hadoop.fs.Path)path, true)).fileStatusFactory(this.fileStatusFactory).exec(this.listeningExecutorService).build();
        return factory.create();
    }

    private UploadObserver newUploadObserver() {
        PreviousInstructionFileDeleter instructionFileDeleter = new PreviousInstructionFileDeleter(this.s3, this.getConf());
        ArrayList<UploadObserver> observers = Lists.newArrayList(instructionFileDeleter);
        if (ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf())) {
            observers.add(new UnencryptedLengthHeaderAdder(this.s3, this.getConf()));
        }
        observers.add(new CacheInvalidator());
        return UploadObserver.chain(observers);
    }

    private UploadPlannerFactory newNonStagingPlannerFactory() {
        return new RegularUploadPlannerFactory(arg_0 -> ((S3NativeFileSystem)this).exists(arg_0));
    }

    public void close() throws IOException {
        ExceptionCollector collector = new ExceptionCollector();
        try {
            this.closeFileCreationSubsystem(collector);
            if (this.listeningExecutorService != null) {
                this.listeningExecutorService.shutdown();
            }
            super.close();
        }
        catch (IOException | RuntimeException e) {
            collector.add(e);
        }
        finally {
            collector.rethrowIfNotEmpty(IOException.class);
        }
    }

    private void closeFileCreationSubsystem(ExceptionCollector collector) {
        if (this.fileCreationSubsystem == null) {
            return;
        }
        try {
            this.fileCreationSubsystem.close();
        }
        catch (IOException | RuntimeException e) {
            logger.error("Failed to close the file system ({}) staging mechanism", (Object)this.uri, (Object)e);
            collector.add(e);
        }
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        UploadPlan uploadPlan = this.getUploadPlanner().plan(absolutePath, overwrite);
        String key = uploadPlan.getKey();
        this.store.invalidateCache(key);
        logger.debug("Creating new file '{}://{}/{}' in S3", new Object[]{this.uri.getScheme(), uploadPlan.getBucket(), key});
        this.clearCache(key);
        Configuration conf = this.getConf();
        boolean cseEnabled = ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf());
        OutputStream outputStream = uploadPlan.getConstraint() != UploadConstraint.SINGLE_PART_UPLOAD ? (!cseEnabled ? new MultipartUploadOutputStream(this.s3, conf, this.store, this.listeningExecutorService, progress, uploadPlan, this.serverSideEncryptionAlgorithm, this.serverSideEncryptionKmsKeyId, this.temporaryDirectoriesGenerator.createTemporaryDirectories()) : new CSEMultipartUploadOutputStream((AmazonS3EncryptionLite)this.s3, uploadPlan, this.getConf(), progress, this.listeningExecutorService, this.temporaryDirectoriesGenerator.createTemporaryDirectory())) : new NativeS3FsOutputStream(conf, this.store, key, progress, this.temporaryDirectoriesGenerator.createTemporaryDirectory());
        return new FSDataOutputStream(outputStream, this.statistics);
    }

    @Deprecated
    public boolean delete(org.apache.hadoop.fs.Path path) throws IOException {
        return this.delete(path, true);
    }

    public boolean delete(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        FileStatus fileStatus;
        logger.debug("Delete called for {}", (Object)path);
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        try {
            fileStatus = this.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            logger.debug("Delete called for '" + path + "' but file does not exist, so returning false");
            return false;
        }
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        this.clearCache(key);
        if (fileStatus.isDirectory()) {
            List<String> keysToDelete = this.listAllKeys(path);
            if (!recursive && keysToDelete.size() > 0) {
                throw new IOException("Can not delete " + path + " at is a not empty directory and recurse option is false");
            }
            this.createParent(path);
            logger.debug("Deleting directory {}", (Object)path);
            try {
                this.doSingleThreadedBatchDelete(keysToDelete);
            }
            catch (IOException ie) {
                throw new IOException("Failed to delete key: " + key, ie);
            }
            try {
                this.store.delete(key + "_$folder$");
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            logger.debug("Deleting file '" + path + "'");
            this.createParent(path);
            this.store.delete(key);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(org.apache.hadoop.fs.Path path) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        if (!this.exists(path)) {
            return false;
        }
        Set<org.apache.hadoop.fs.Path> set = this.deleteOnExit;
        synchronized (set) {
            this.deleteOnExit.add(path);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDeleteOnExit(org.apache.hadoop.fs.Path path) {
        Set<org.apache.hadoop.fs.Path> set = this.deleteOnExit;
        synchronized (set) {
            return this.deleteOnExit.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<org.apache.hadoop.fs.Path> set = this.deleteOnExit;
        synchronized (set) {
            ArrayList<String> keysToDelete = new ArrayList<String>();
            for (org.apache.hadoop.fs.Path path : this.deleteOnExit) {
                try {
                    if (!this.exists(path)) continue;
                    if (this.isDirectory(path)) {
                        this.delete(path, true);
                        continue;
                    }
                    keysToDelete.add(this.pathToKey(this.makeAbsolute(path)));
                }
                catch (IOException e) {
                    logger.info("Ignoring failure in batch deleteOnExit", (Throwable)e);
                }
            }
            if (!keysToDelete.isEmpty()) {
                try {
                    this.doSingleThreadedBatchDelete(keysToDelete);
                }
                catch (IOException e) {
                    logger.info("Ignoring failure in batch deleteOnExit", (Throwable)e);
                }
            }
            this.deleteOnExit.clear();
        }
    }

    public FileStatus getFileStatus(org.apache.hadoop.fs.Path path) throws IOException {
        PartialListing listing;
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        if (this.getStagingMechanism().isStagingDirectoryPath(path)) {
            return this.getStagingMechanism().getFileStatus(path);
        }
        String key = this.pathToKey(absolutePath);
        if (key.length() == 0) {
            return this.newDirectory(absolutePath);
        }
        FileStatus keyStatus = this.getFileStatusFromCache(absolutePath);
        if (keyStatus != null) {
            return keyStatus;
        }
        logger.debug("getFileStatus retrieving metadata for key '" + key + "'");
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (fileMetadata != null) {
            logger.debug("getFileStatus returning 'file' for key '" + key + "'");
            return this.newFile(fileMetadata, absolutePath, false);
        }
        if (this.store.retrieveMetadata(key + "_$folder$") != null) {
            logger.debug("getFileStatus returning 'directory' for key '" + key + "' as '" + key + "_$folder$" + "' exists");
            return this.newDirectory(absolutePath);
        }
        logger.debug("getFileStatus listing key '" + key + "'");
        String continuationToken = null;
        int keysCount = 0;
        HashSet<String> listingDirs = Sets.newHashSetWithExpectedSize(1);
        do {
            listing = this.store.list(key, 1, null, continuationToken, false);
            listingDirs.addAll(listing.getCommonPrefixes());
        } while ((continuationToken = listing.getNextContinuationToken()) != null && (keysCount += listing.getFiles().size()) == 0 && listingDirs.isEmpty());
        if (keysCount > 0 || !listingDirs.isEmpty()) {
            logger.debug("getFileStatus returning 'directory' for key '" + key + "' as it has contents ");
            if (ConfigurationUtils.isFolderObjectAutoInsert(this.getConf())) {
                String folderKey = key + "_$folder$";
                logger.debug("getFileStatus creating '" + folderKey + "' as key '" + key + "' exists as a folder ");
                try {
                    this.store.storeEmptyFile(folderKey);
                }
                catch (Exception e) {
                    logger.debug("getFileStatus cannot insert '" + folderKey + "'", (Throwable)e);
                }
            }
            return this.newDirectory(absolutePath);
        }
        logger.debug("getFileStatus could not find key '" + key + "'");
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    private FileStatus getFileStatusFromCache(org.apache.hadoop.fs.Path absolutePath) throws IOException {
        String key = this.pathToKey(absolutePath);
        if (useCache.get().booleanValue()) {
            this.verifyCache(key);
            return cachedFileStatus.get().getFileStatus(key, this);
        }
        return null;
    }

    private void verifyCache(String key) throws IOException {
        if (!cachedFileStatus.get().isCached(key)) {
            this.cache(key);
        }
    }

    private List<String> listAllKeys(org.apache.hadoop.fs.Path path) throws IOException {
        PartialListing listing;
        ArrayList<String> allKeys = new ArrayList<String>();
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        String continuationToken = null;
        do {
            listing = this.store.list(key, 1000, null, continuationToken, true);
            List<FileMetadata> files = listing.getFiles();
            allKeys.ensureCapacity(allKeys.size() + files.size());
            for (FileMetadata fileMetadata : files) {
                allKeys.add(fileMetadata.getKey());
            }
        } while ((continuationToken = listing.getNextContinuationToken()) != null);
        return allKeys;
    }

    public org.apache.hadoop.fs.Path[] getEmptySubDirPaths(org.apache.hadoop.fs.Path parent) throws IOException {
        PartialListing listing;
        this.checkNotStagingDirectoryPath(parent);
        HashSet<org.apache.hadoop.fs.Path> emptySubDirs = new HashSet<org.apache.hadoop.fs.Path>();
        HashSet<org.apache.hadoop.fs.Path> visitedNonEmptyPaths = new HashSet<org.apache.hadoop.fs.Path>();
        String key = this.pathToKey(parent);
        String continuationToken = null;
        URI pathUri = parent.toUri();
        do {
            org.apache.hadoop.fs.Path subDirPath;
            String relativePath;
            listing = this.store.list(key, 1000, null, continuationToken, false);
            for (String commonPrefix : listing.getCommonPrefixes()) {
                org.apache.hadoop.fs.Path subPath = S3UriUtils.keyToPath(commonPrefix);
                relativePath = pathUri.relativize(subPath.toUri()).getPath();
                subDirPath = new org.apache.hadoop.fs.Path(parent, relativePath);
                visitedNonEmptyPaths.add(subDirPath);
            }
            for (FileMetadata fileMetadata : listing.getFiles()) {
                org.apache.hadoop.fs.Path subpath = S3UriUtils.keyToPath(fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                if (fileMetadata.getKey().equals(key + "/") || !relativePath.endsWith("_$folder$")) continue;
                subDirPath = new org.apache.hadoop.fs.Path(parent, relativePath.substring(0, relativePath.indexOf("_$folder$")));
                if (!visitedNonEmptyPaths.contains(subDirPath)) {
                    emptySubDirs.add(subDirPath);
                    continue;
                }
                visitedNonEmptyPaths.remove(subDirPath);
            }
        } while ((continuationToken = listing.getNextContinuationToken()) != null);
        return emptySubDirs.toArray(new org.apache.hadoop.fs.Path[0]);
    }

    public FileStatus[] listStatus(org.apache.hadoop.fs.Path path) throws IOException {
        return this.listStatus(path, false);
    }

    public FileStatus[] listStatus(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        logger.debug("listStatus {} with recursive {}", (Object)path.toString(), (Object)recursive);
        this.checkNotStagingDirectoryPath(path);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        String key = this.pathToKey(absolutePath);
        List<FileStatus> keyStatus = this.listFromCache(absolutePath);
        if (keyStatus != null) {
            return keyStatus.toArray(new FileStatus[0]);
        }
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null) {
            return new FileStatus[]{this.newFile(meta, absolutePath, false)};
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String continuationToken = null;
        do {
            String relativePath;
            org.apache.hadoop.fs.Path subpath;
            listing = this.store.list(key, 1000, null, continuationToken, recursive);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                subpath = S3UriUtils.keyToPath(fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                String fileMetadataKey = fileMetadata.getKey();
                if (fileMetadataKey.equals(key + "/")) continue;
                if (relativePath.endsWith("_$folder$")) {
                    status.add(this.newDirectory(new org.apache.hadoop.fs.Path(absolutePath, relativePath.substring(0, relativePath.indexOf("_$folder$")))));
                    continue;
                }
                if (fileMetadataKey.endsWith("/")) {
                    if (!recursive) continue;
                    status.add(this.newDirectory(new org.apache.hadoop.fs.Path(absolutePath, relativePath)));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath, true));
            }
            for (String commonPrefix : listing.getCommonPrefixes()) {
                subpath = S3UriUtils.keyToPath(commonPrefix);
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(new org.apache.hadoop.fs.Path(absolutePath, relativePath)));
            }
        } while ((continuationToken = listing.getNextContinuationToken()) != null);
        if (status.isEmpty() && key.length() > 0 && this.store.retrieveMetadata(key + "_$folder$") == null && this.store.retrieveMetadata(key + "/") == null) {
            throw new FileNotFoundException("File " + path + " does not exist.");
        }
        return status.toArray(new FileStatus[0]);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        FileMetadata metadata;
        if (!ConfigurationUtils.isListFilesIncrementalFetchEnabled(this.getConf())) {
            return super.listFiles(path, recursive);
        }
        logger.debug("listFiles {} with incremental fetch and recursive={}", (Object)path, (Object)recursive);
        this.checkNotStagingDirectoryPath(path);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        String key = this.pathToKey(absolutePath);
        if (key.length() > 0 && (metadata = this.store.retrieveMetadata(key)) != null) {
            FileStatus file = this.newFile(metadata, absolutePath, false);
            BlockLocation[] locations = this.getFileBlockLocations(file, 0L, file.getLen());
            return RemoteIterators.singleton(new LocatedFileStatus(file, locations));
        }
        FileIterator files = new FileIterator(key, recursive);
        if (files.isListingEmpty() && key.length() > 0 && this.store.retrieveMetadata(key + "_$folder$") == null) {
            throw new FileNotFoundException("File " + path + " does not exist.");
        }
        return files;
    }

    private List<FileStatus> listFromCache(org.apache.hadoop.fs.Path absolutePath) throws IOException {
        String key = this.pathToKey(absolutePath);
        if (useCache.get().booleanValue()) {
            this.verifyCache(key);
            return cachedFileStatus.get().listStatus(key);
        }
        return null;
    }

    private TreeMap<String, FileStatus> fetchKeysFromStore(String prefix, String startAfter, Integer maxKeys) throws IOException {
        FileMetadata meta;
        TreeMap<String, FileStatus> prefetchMap = new TreeMap<String, FileStatus>();
        int numListedKeys = 0;
        if (startAfter != null && !startAfter.isEmpty() && (meta = this.store.retrieveMetadata(startAfter)) != null) {
            prefetchMap.put(startAfter, this.newFile(meta, S3UriUtils.keyToPath(meta.getKey()), false));
            ++numListedKeys;
        }
        int numKeysToList = this.getNumKeysToList(maxKeys, numListedKeys);
        String previousKey = null;
        String continuationToken = null;
        while (numKeysToList > 0) {
            PartialListing listing = this.store.list(prefix, numKeysToList, startAfter, continuationToken, true);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                String relativeKey;
                org.apache.hadoop.fs.Path subpath = S3UriUtils.keyToPath(fileMetadata.getKey());
                String currentKey = fileMetadata.getKey();
                this.checkClosedFolders(previousKey, currentKey, prefetchMap);
                previousKey = currentKey;
                if (currentKey.endsWith("_$folder$")) {
                    relativeKey = currentKey.substring(0, currentKey.indexOf("_$folder$"));
                    this.insertDirectory(relativeKey, prefetchMap);
                    continue;
                }
                if (currentKey.endsWith("/")) {
                    relativeKey = currentKey.substring(0, currentKey.length() - 1);
                    this.insertDirectory(relativeKey, prefetchMap);
                    continue;
                }
                prefetchMap.put(currentKey, this.newFile(fileMetadata, subpath, true));
            }
            continuationToken = listing.getNextContinuationToken();
            if (startAfter == null) break;
            numKeysToList = this.getNumKeysToList(maxKeys, numListedKeys += numKeysToList);
        }
        return prefetchMap;
    }

    private void insertDirectory(String key, TreeMap<String, FileStatus> prefetchMap) {
        if (prefetchMap.isEmpty() || prefetchMap.firstKey().compareTo(key) < 0) {
            prefetchMap.put(key, this.newDirectory(S3UriUtils.keyToPath(key).makeQualified(this.getUri(), this.getWorkingDirectory())));
        }
    }

    private int getNumKeysToList(Integer maxKeys, int numListed) {
        if (maxKeys != null) {
            int remaining = maxKeys - numListed;
            if (remaining > 1000) {
                return 1000;
            }
            return Math.max(remaining, 0);
        }
        return 1000;
    }

    private void checkClosedFolders(String previousKey, String currentKey, TreeMap<String, FileStatus> prefetchMap) {
        if (previousKey == null || !previousKey.contains("/")) {
            return;
        }
        String[] previousFolders = previousKey.split("/");
        String[] newFolders = currentKey.split("/");
        String currentPath = "";
        boolean differ = false;
        for (int i = 0; i < previousFolders.length - 1; ++i) {
            currentPath = currentPath + previousFolders[i];
            if (differ || newFolders.length <= i || !previousFolders[i].equals(newFolders[i])) {
                differ = true;
                this.insertDirectory(currentPath, prefetchMap);
            }
            currentPath = currentPath + "/";
        }
    }

    private void cache(String key) throws IOException {
        TreeMap<String, FileStatus> keyMap = this.fetchKeysFromStore("", key, 1000);
        cachedFileStatus.get().buildCache(keyMap, key);
    }

    private FileStatus newFile(FileMetadata meta, org.apache.hadoop.fs.Path path, boolean lazyLoad) {
        if (lazyLoad && ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf()) && this.getConf().getBoolean("fs.s3.cse.plaintextLength.enabled", true)) {
            return new FileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), 0L, null, this.fileSystemOwner.getFullUserName(), this.fileSystemOwner.getGroup(), path.makeQualified(this.getUri(), this.getWorkingDirectory())){
                private long plaintextLength;
                {
                    this.plaintextLength = -1L;
                }

                public long getLen() {
                    if (this.plaintextLength == -1L) {
                        String bucket = S3UriUtils.pathToBucket(this.getPath());
                        String key = S3NativeFileSystem.this.pathToKey(this.getPath());
                        this.plaintextLength = CSEUtils.getPlaintextLength(S3NativeFileSystem.this.s3, bucket, key, null, S3NativeFileSystem.this.getConf());
                    }
                    return this.plaintextLength;
                }
            };
        }
        return this.fileStatusFactory.newFile(path, meta.getLength(), meta.getLastModified());
    }

    FileStatus newDirectory(org.apache.hadoop.fs.Path path) {
        return this.fileStatusFactory.newDirectory(path);
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path targetPath, FsPermission permission) throws IOException {
        this.checkNotStagingDirectoryPath(targetPath);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(targetPath);
        org.apache.hadoop.fs.Path parentPath = null;
        if (absolutePath != null) {
            parentPath = absolutePath.getParent();
        }
        ArrayList<org.apache.hadoop.fs.Path> pathsToMake = new ArrayList<org.apache.hadoop.fs.Path>();
        while (parentPath != null) {
            pathsToMake.add(0, absolutePath);
            absolutePath = parentPath;
            parentPath = absolutePath.getParent();
        }
        boolean result = true;
        for (org.apache.hadoop.fs.Path path : pathsToMake) {
            result &= this.mkdir(path);
        }
        return result;
    }

    private boolean mkdir(org.apache.hadoop.fs.Path path) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                throw new IOException(String.format("Can't make directory for path '%s' since it is a file.", path));
            }
        }
        catch (FileNotFoundException e) {
            logger.debug("Making dir '" + path + "' in S3");
            String key = this.pathToKey(path) + "_$folder$";
            this.store.storeEmptyFile(key);
        }
        return true;
    }

    public FSDataInputStream open(org.apache.hadoop.fs.Path path, int bufferSize) throws IOException {
        return this.open(path, bufferSize, null);
    }

    private FSDataInputStream open(org.apache.hadoop.fs.Path path, int bufferSize, Configuration selectOptions) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(path);
        FileStatus fs = this.getFileStatus(path);
        if (fs.isDirectory()) {
            throw new IOException("'" + path + "' is a directory");
        }
        logger.info("Opening '" + path + "' for reading");
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = this.pathToKey(absolutePath);
        long contentLength = fs.getLen();
        FSInputStream fsIn = this.store.open(key, contentLength, this.statistics, selectOptions);
        return new FSDataInputStream((InputStream)new BufferedFSInputStream(fsIn, bufferSize));
    }

    private void createParent(org.apache.hadoop.fs.Path path) throws IOException {
        String parentKey;
        org.apache.hadoop.fs.Path parentPath = path.getParent();
        if (parentPath != null && !parentPath.isRoot() && (parentKey = this.pathToKey(this.makeAbsolute(parentPath))).length() > 0 && !this.exists(S3UriUtils.keyToPath(parentKey + "_$folder$"))) {
            this.store.storeEmptyFile(parentKey + "_$folder$");
        }
    }

    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        boolean srcIsFile;
        String dstKey;
        int renameVersion = ConfigurationUtils.getRenameAlgorithmVersion(this.getConf());
        logger.info("rename {} {}", (Object)src.toString(), (Object)(dst.toString() + " using algorithm version " + renameVersion));
        this.checkNotStagingDirectoryPath(src);
        this.checkNotStagingDirectoryPath(dst);
        this.multipartUploadCleaner.scheduleMultipartCleanup(src);
        this.multipartUploadCleaner.scheduleMultipartCleanup(dst);
        String srcKey = this.pathToKey(this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        String debugPreamble = "Renaming '" + src + "' to '" + dst + "' - ";
        boolean shouldCreateDst = true;
        try {
            boolean dstIsFile = this.getFileStatus(dst).isFile();
            if (dstIsFile) {
                logger.debug(debugPreamble + "returning false as dst is an already existing file");
                return false;
            }
            if (renameVersion == 2) {
                shouldCreateDst = false;
                dstKey = this.pathToKey(this.makeAbsolute(dst));
            } else {
                dstKey = this.pathToKey(this.makeAbsolute(new org.apache.hadoop.fs.Path(dst, src.getName())));
            }
            logger.debug(debugPreamble + "using " + dstKey + " as output directory");
        }
        catch (FileNotFoundException e) {
            dstKey = this.pathToKey(this.makeAbsolute(dst));
            logger.debug(debugPreamble + "using " + dstKey + " as output destination");
            try {
                if (this.getFileStatus(dst.getParent()).isFile()) {
                    logger.debug(debugPreamble + "returning false as dst parent exists and is a file ");
                    return false;
                }
            }
            catch (FileNotFoundException ex) {
                logger.debug(debugPreamble + "returning false as dst parent does not exist " + dst.getParent().toString());
                return false;
            }
        }
        this.clearCache(srcKey);
        this.clearCache(dstKey);
        try {
            srcIsFile = this.getFileStatus(src).isFile();
        }
        catch (FileNotFoundException e) {
            logger.debug(debugPreamble + "returning false as src does not exist");
            return false;
        }
        if (srcIsFile) {
            logger.debug(debugPreamble + "src is file, so doing copy then delete in S3");
            this.store.copy(srcKey, dstKey);
            this.store.delete(srcKey);
        } else {
            logger.debug(debugPreamble + "src is directory, so copying contents");
            List<String> keysToRename = this.listAllKeys(src);
            if (shouldCreateDst) {
                this.store.storeEmptyFile(dstKey + "_$folder$");
            }
            this.doMultiThreadedRename(keysToRename, srcKey, dstKey);
            try {
                this.store.delete(srcKey + "_$folder$");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            logger.debug(debugPreamble + "done");
        }
        return true;
    }

    private void doMultiThreadedRename(List<String> keysToRename, String srcDirKey, String dstDirKey) throws IOException {
        EmrFSFutureCallback<String> emrFsFutureCallback = new EmrFSFutureCallback<String>(true);
        for (String srcFileKey : keysToRename) {
            if (emrFsFutureCallback.isCancelled()) break;
            String dstFileKey = EmrFsUtils.makeDestFileKey(srcDirKey, dstDirKey, srcFileKey);
            logger.debug("Src key {} to Dst Key {} DSTKEY {}", new Object[]{srcFileKey, dstFileKey, dstDirKey});
            for (Callable<String> callable : this.store.createCopyCallables(srcFileKey, dstFileKey)) {
                emrFsFutureCallback.registerFuture(this.listeningExecutorService.submit(callable));
            }
        }
        try {
            emrFsFutureCallback.ensureFuturesComplete();
        }
        catch (RuntimeException re) {
            try {
                this.doSingleThreadedBatchDelete(emrFsFutureCallback.getResults());
            }
            catch (IOException ioe) {
                logger.error("Failed to clean up {} on failed rename", (Object)dstDirKey, (Object)ioe);
            }
            throw new IOException(String.format("Failed to copy from %s to %s on rename", srcDirKey, dstDirKey), re);
        }
        try {
            this.doSingleThreadedBatchDelete(keysToRename);
        }
        catch (IOException ioe) {
            throw new IOException(String.format("Failed to delete %s on rename", srcDirKey), ioe);
        }
    }

    private void doSingleThreadedBatchDelete(List<String> keysToDelete) throws IOException {
        this.store.deleteAll(keysToDelete);
    }

    @Override
    public FSDataInputStream select(org.apache.hadoop.fs.Path path, Configuration selectOptions, int bufferSize) throws IOException {
        return this.open(path, bufferSize, selectOptions);
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return this.getStagingMechanism();
    }

    private StagingMechanism getStagingMechanism() {
        return this.getFileCreationSubsystem().getStagingMechanism();
    }

    private UploadPlanner getUploadPlanner() {
        return this.getFileCreationSubsystem().getUploadPlanner();
    }

    private FileCreationSubsystem getFileCreationSubsystem() {
        Preconditions.checkState(this.fileCreationSubsystem != null, "FileSystem must be initialized");
        return this.fileCreationSubsystem;
    }

    public boolean isOrderedListEnabled() {
        return !ConfigurationUtils.isClientSideEncryptionEnabled(this.getConf());
    }

    public Comparator<org.apache.hadoop.fs.Path> listOrder() {
        this.checkOrderedListEnabled();
        Preconditions.checkState(this.listOrder != null, "FileSystem must be initialized");
        return this.listOrder;
    }

    public OrderedListingBuilder listFilesInOrder(@Nonnull org.apache.hadoop.fs.Path path) throws IOException {
        this.checkOrderedListEnabled();
        Preconditions.checkState(this.store != null, "FileSystem must be initialized");
        this.checkPath(path);
        this.checkNotStagingDirectoryPath(path);
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        this.multipartUploadCleaner.scheduleMultipartCleanup(absolutePath);
        String key = this.pathToKey(absolutePath);
        return new OnlyFilesOrderedListing.Builder(this.store, arg_0 -> ((S3NativeFileSystem)this).checkPath(arg_0), this::newLocatedFileStatus, this.getConf(), key);
    }

    private LocatedFileStatus newLocatedFileStatus(FileMetadata file) {
        org.apache.hadoop.fs.Path filePath = S3UriUtils.keyToPath(file.getKey());
        FileStatus status = this.newFile(file, filePath, true);
        try {
            BlockLocation[] locations = this.getFileBlockLocations(status, 0L, status.getLen());
            return new LocatedFileStatus(status, locations);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void checkOrderedListEnabled() {
        if (!this.isOrderedListEnabled()) {
            throw new UnsupportedOperationException("Ordered list is disabled");
        }
    }

    private final class FileIterator
    implements RemoteIterator<LocatedFileStatus> {
        @NonNull
        private final String key;
        private final boolean recursive;
        private boolean isListingEmpty = true;
        private Iterator<FileStatus> filesInBatch;
        private String continuationToken;

        public boolean hasNext() throws IOException {
            this.loadNextBatchIfNeeded();
            return this.filesInBatch.hasNext();
        }

        public LocatedFileStatus next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("All files have already been listed for " + S3NativeFileSystem.this.makeQualified(S3UriUtils.keyToPath(this.key)));
            }
            FileStatus file = this.filesInBatch.next();
            BlockLocation[] locations = S3NativeFileSystem.this.getFileBlockLocations(file, 0L, file.getLen());
            return new LocatedFileStatus(file, locations);
        }

        boolean isListingEmpty() throws IOException {
            return !this.hasNext() && this.isListingEmpty;
        }

        private void loadNextBatchIfNeeded() throws IOException {
            while (this.filesInBatch == null || !this.filesInBatch.hasNext() && this.continuationToken != null) {
                PartialListing listing = S3NativeFileSystem.this.store.list(this.key, 1000, null, this.continuationToken, this.recursive);
                this.isListingEmpty = this.isListingEmpty && listing.isEmpty();
                this.filesInBatch = listing.getFiles().stream().filter(file -> !this.isFolderMarker((FileMetadata)file)).map(this::newFileStatus).iterator();
                this.continuationToken = listing.getNextContinuationToken();
            }
        }

        private boolean isFolderMarker(FileMetadata file) {
            return file.getKey().endsWith("_$folder$") || file.getKey().endsWith("/");
        }

        private FileStatus newFileStatus(FileMetadata file) {
            org.apache.hadoop.fs.Path filePath = S3UriUtils.keyToPath(file.getKey());
            return S3NativeFileSystem.this.newFile(file, filePath, true);
        }

        public FileIterator(String key, boolean recursive) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            this.recursive = recursive;
        }
    }

    private final class CacheInvalidator
    extends AfterUploadCompletionObserver {
        @Override
        protected void afterUpload(String bucket, String key) {
            S3NativeFileSystem.this.store.invalidateCache(key);
            S3NativeFileSystem.this.clearCache(key);
        }
    }

    private class NativeS3FsOutputStream
    extends OutputStream
    implements Abortable {
        private final Configuration conf;
        private final NativeFileSystemStore store;
        private final String key;
        private final TemporaryFiles temporaryFiles;
        private final TemporaryDirectories temporaryDirectories;
        private final Path backupFilePath;
        private OutputStream backupStream;
        private MessageDigest digest;
        private boolean closed = false;
        private boolean aborted = false;
        private Progressable progress;

        public NativeS3FsOutputStream(Configuration conf, NativeFileSystemStore store, String key, Progressable progress, TemporaryDirectories temporaryDirectories) throws IOException {
            this.conf = conf;
            this.store = store;
            this.key = key;
            this.temporaryDirectories = temporaryDirectories;
            this.temporaryFiles = new TemporaryFiles(temporaryDirectories);
            this.backupFilePath = this.temporaryFiles.create();
            this.progress = progress;
            logger.info("OutputStream for key '" + key + "' writing to tempfile '" + this.backupFilePath + "'");
            try {
                this.digest = MessageDigest.getInstance("MD5");
                this.backupStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.backupFilePath.toFile()), this.digest));
            }
            catch (NoSuchAlgorithmException e) {
                logger.warn("Cannot load MD5 digest algorithm,skipping message integrity check.", (Throwable)e);
                this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFilePath.toFile()));
            }
        }

        @Override
        public void flush() throws IOException {
            this.backupStream.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.backupStream.close();
                if (this.aborted) {
                    logger.info("Outputstream for key '" + this.key + "' was aborted, not performing upload.");
                } else {
                    logger.info("Outputstream for key '" + this.key + "' is being closed. Beginning upload.");
                    byte[] md5Hash = this.digest == null ? null : this.digest.digest();
                    this.store.storeFile(this.key, this.backupFilePath.toFile(), md5Hash, this.progress);
                }
            }
            catch (IOException | RuntimeException e) {
                logger.info("Outputstream for key '" + this.key + "' failed, marking stream as aborted.");
                this.aborted = true;
                throw e;
            }
            finally {
                this.temporaryFiles.delete(this.backupFilePath);
                this.temporaryDirectories.close();
                super.close();
                this.closed = true;
            }
            logger.info("OutputStream for key '" + this.key + "': upload complete");
        }

        public synchronized void abort() throws IOException {
            this.aborted = true;
            this.close();
        }

        @Override
        public void write(int writeByte) throws IOException {
            this.backupStream.write(writeByte);
        }

        @Override
        public void write(byte[] writeByte, int off, int len) throws IOException {
            this.backupStream.write(writeByte, off, len);
        }
    }
}

