/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class PartialListing {
    private final List<FileMetadata> files = new ArrayList<FileMetadata>();
    private final List<String> commonPrefixes = new ArrayList<String>();
    private final String startAfter;
    private final String continuationToken;
    private String nextContinuationToken;

    public PartialListing(String startAfter, String continuationToken) {
        this.startAfter = startAfter;
        this.continuationToken = continuationToken;
    }

    public void addFile(S3ObjectSummary summary) {
        if (!CSEUtils.isInstructionFile(summary.getKey())) {
            this.files.add(new FileMetadata(summary.getKey(), summary.getSize(), summary.getLastModified().getTime()));
        }
    }

    public void addFiles(List<S3ObjectSummary> summary) {
        for (S3ObjectSummary v : summary) {
            this.addFile(v);
        }
    }

    public void addDirs(List<String> commonPrefix) {
        this.commonPrefixes.addAll(commonPrefix);
    }

    public boolean isEmpty() {
        return this.files.isEmpty() && this.commonPrefixes.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("PartialListing startAfter:%s continuationToken:%s nextContinuationToken:%s %d dirs %d files:", this.startAfter == null ? "" : this.startAfter, this.continuationToken == null ? "" : this.continuationToken, this.nextContinuationToken == null ? "" : this.nextContinuationToken, this.commonPrefixes.size(), this.files.size()));
        if (this.commonPrefixes.size() > 0 || this.files.size() > 0) {
            sb.append("\n  ");
        }
        sb.append(Joiner.on("\n  ").join(this.commonPrefixes));
        for (FileMetadata v : this.files) {
            sb.append("\n  " + v.getKey());
        }
        return sb.toString();
    }

    public List<FileMetadata> getFiles() {
        return this.files;
    }

    public List<String> getCommonPrefixes() {
        return this.commonPrefixes;
    }

    public String getNextContinuationToken() {
        return this.nextContinuationToken;
    }

    public void setNextContinuationToken(String nextContinuationToken) {
        this.nextContinuationToken = nextContinuationToken;
    }
}

