/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectories;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryFiles;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AbortMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.CompleteMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3n.NativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.ProgressableResettableBufferedFileInputStream;
import com.amazon.ws.emr.hadoop.fs.s3n.SpeculativeUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartETag;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.FutureCallback;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.Futures;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.codec.binary.Base64;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.codec.binary.Hex;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartUploadOutputStream
extends OutputStream
implements Abortable {
    private static final Logger logger = LoggerFactory.getLogger(MultipartUploadOutputStream.class);
    public static final double MAX_PART_SIZE_THRESHOLD_PERCENT = 0.7;
    private final AmazonS3Lite s3;
    private final ListeningExecutorService exec;
    private final Progressable progressable;
    private final UploadPlan uploadPlan;
    private final String bucket;
    private final String key;
    private final String s3path;
    private final long partSize;
    private final double partsCompletedThresholdPercent;
    private final double fractionPartAvgCompletionTime;
    private final int maxPartAttempts;
    private final ObjectMetadata metadata;
    private final NativeFileSystemStore store;
    private final Configuration conf;
    private final ConcurrentHashMap<Integer, List<MultiPartUploadFuture>> partNumFutureMap;
    private final Object partNumFutureMapHandle = new Object();
    private final Set<Integer> incompletePartNums;
    private final TemporaryFiles temporaryFiles;
    private final TemporaryDirectories temporaryDirectories;
    private int partCount = 0;
    private long currentPartSize = 0L;
    private DigestOutputStream currentOutput;
    private Path currentPath;
    private String uploadId;
    private String serverSideEncryptionKmsKeyId;
    private long totalLength = 0L;
    private boolean multipartUploadInitiated;
    private boolean closed = false;
    private boolean closing = false;

    public MultipartUploadOutputStream(AmazonS3Lite s3, Configuration conf, NativeFileSystemStore store, ListeningExecutorService exec, Progressable progressable, UploadPlan uploadPlan, String serverSideEncryptionAlgorithm, String serverSideEncryptionKmsKeyId, TemporaryDirectories temporaryDirectories) {
        MultipartUploadOutputStream.validateUploadPlan(uploadPlan);
        this.s3 = EmrFsUtils.getAmazonS3LiteWithRetryPolicy(s3);
        this.multipartUploadInitiated = false;
        this.metadata = new ObjectMetadata();
        this.metadata.setContentType("binary/octet-stream");
        if (!Strings.isNullOrEmpty(serverSideEncryptionAlgorithm)) {
            this.metadata.setSSEAlgorithm(serverSideEncryptionAlgorithm);
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }
        this.store = store;
        this.exec = exec;
        this.progressable = progressable;
        this.partNumFutureMap = new ConcurrentHashMap();
        this.incompletePartNums = Collections.synchronizedSet(new HashSet());
        this.temporaryDirectories = temporaryDirectories;
        this.temporaryFiles = new TemporaryFiles(temporaryDirectories);
        this.uploadPlan = uploadPlan;
        this.bucket = uploadPlan.getBucket();
        this.key = uploadPlan.getKey();
        this.s3path = "s3://" + this.bucket + "/" + this.key;
        this.conf = conf;
        this.partSize = ConfigurationUtils.getDefaultPartSize(conf);
        this.partsCompletedThresholdPercent = ConfigurationUtils.getPartsCompletedThresholdPercent(conf);
        this.fractionPartAvgCompletionTime = ConfigurationUtils.getFractionPartAvgCompletionTime(conf);
        this.maxPartAttempts = ConfigurationUtils.getPartAttempts(conf);
        this.openNewPart();
    }

    private static void validateUploadPlan(UploadPlan uploadPlan) {
        ExtraUploadMetadata extraUploadMetadata = uploadPlan.getExtraUploadMetadata();
        Preconditions.checkArgument(extraUploadMetadata.getConcurrencyToken() == null, "Expected upload plan not to contain a ConcurrencyToken");
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long capacityLeft = this.capacityLeft();
        int offset = off;
        int length = len;
        while (capacityLeft < (long)length) {
            int capacityLeftInt = (int)capacityLeft;
            this.currentOutput.write(b, offset, capacityLeftInt);
            this.closeAndSchedulePart();
            offset += capacityLeftInt;
            length -= capacityLeftInt;
            capacityLeft = this.capacityLeft();
        }
        this.currentOutput.write(b, offset, length);
        this.currentPartSize += (long)length;
        this.totalLength += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.capacityLeft() < 1L) {
            this.closeAndSchedulePart();
        }
        this.currentOutput.write(b);
        ++this.currentPartSize;
        ++this.totalLength;
    }

    @Override
    public void flush() {
    }

    private void uploadSinglePart() throws IOException {
        try {
            this.currentOutput.close();
            byte[] md5Hash = this.currentOutput.getMessageDigest().digest();
            this.store.storeFile(this.key, this.currentPath.toFile(), md5Hash, this.progressable);
        }
        finally {
            this.temporaryFiles.delete(this.currentPath);
        }
    }

    private MultiPartUploadFuture createMultiPartUploadFuture(long partSize, MultipartUploadCallable multipartUploadCallable, int partNum) {
        ListenableFuture<PartETag> future = this.exec.submit(multipartUploadCallable);
        MultipartUploadFutureCallBack futureCallBack = new MultipartUploadFutureCallBack(future, partNum);
        Futures.addCallback(future, futureCallBack, this.exec);
        MultiPartUploadFuture multiPartUploadFuture = new MultiPartUploadFuture(partSize, future, multipartUploadCallable);
        DateTime startTime = DateTime.now();
        multiPartUploadFuture.setStartTime(startTime);
        return multiPartUploadFuture;
    }

    private boolean shouldSpawnNewFuture(MultiPartUploadFuture remFuture) {
        long totalTime = 0L;
        int completedFutures = 0;
        for (Map.Entry<Integer, List<MultiPartUploadFuture>> entry : this.partNumFutureMap.entrySet()) {
            MultiPartUploadFuture multipartUploadFuture;
            int partNum = entry.getKey();
            if (this.incompletePartNums.contains(partNum) || (multipartUploadFuture = entry.getValue().get(0)).getEndTime() == null || !((double)multipartUploadFuture.getPartSize() / (double)this.partSize >= 0.7)) continue;
            totalTime += multipartUploadFuture.getEndTime().getMillis() - multipartUploadFuture.getStartTime().getMillis();
            ++completedFutures;
        }
        if (completedFutures == 0) {
            return false;
        }
        double avgCompletionTime = (double)totalTime / (double)completedFutures;
        long timeSinceFutureStarted = DateTime.now().getMillis() - remFuture.getStartTime().getMillis();
        double fractionPartsIncomplete = (double)this.incompletePartNums.size() / (double)this.partNumFutureMap.size();
        double thresholdTimeForSpawn = (1.0 + fractionPartsIncomplete) * (avgCompletionTime * this.fractionPartAvgCompletionTime);
        logger.debug("Threshold time before spawn: " + thresholdTimeForSpawn);
        logger.debug("Time since incomplete future started: " + timeSinceFutureStarted);
        if ((double)timeSinceFutureStarted > thresholdTimeForSpawn) {
            logger.debug("Incomplete future exceeded threshold, will start new one..");
            return true;
        }
        return false;
    }

    private void spawnNewFutureIfNeeded(int partNum) throws IOException {
        List<MultiPartUploadFuture> multiPartUploadFutures = this.partNumFutureMap.get(partNum);
        logger.debug("Number of running attempts for: " + partNum + " are: " + multiPartUploadFutures.size());
        MultiPartUploadFuture multiPartUploadFuture = multiPartUploadFutures.get(multiPartUploadFutures.size() - 1);
        if (this.shouldSpawnNewFuture(multiPartUploadFuture)) {
            if (multiPartUploadFutures.size() >= this.maxPartAttempts) {
                logger.error("Upload attempts for part num: " + partNum + " have already reached max limit of: " + this.maxPartAttempts + ", will throw exception and fail");
                throw new IllegalStateException("Reached max limit of upload attempts for part");
            }
            logger.debug("Creating new future for partNum: " + partNum);
            MultipartUploadCallable multipartUploadCallable = multiPartUploadFuture.getMultipartUploadCallable();
            Path origPartFile = multipartUploadCallable.getPartFilePath();
            Path clonePartPath = SpeculativeUtils.clonePartFileIfNotAlreadyCompleted(this.temporaryFiles, origPartFile, partNum);
            if (clonePartPath == null) {
                return;
            }
            ++this.partCount;
            MultipartUploadCallable newMultiPartUploadCallable = new MultipartUploadCallable(multipartUploadCallable.getPartNumber(), clonePartPath, multipartUploadCallable.getMd5sum(), multipartUploadCallable.getMd5hex());
            MultiPartUploadFuture newMultipartUploadFuture = this.createMultiPartUploadFuture(multiPartUploadFuture.getPartSize(), newMultiPartUploadCallable, partNum);
            multiPartUploadFutures.add(newMultipartUploadFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadMultiParts() throws ExecutionException, InterruptedException, IOException {
        this.closeAndSchedulePart();
        int partNumbers = this.partCount;
        while (this.incompletePartNums.size() != 0) {
            int completedFutures = partNumbers - this.incompletePartNums.size();
            if (completedFutures > 0 && (double)completedFutures >= this.partsCompletedThresholdPercent * (double)partNumbers) {
                logger.debug(completedFutures + " part(s) completed, checking heuristic...");
                Set<Integer> set = this.incompletePartNums;
                synchronized (set) {
                    for (int partNum : this.incompletePartNums) {
                        this.spawnNewFutureIfNeeded(partNum);
                    }
                }
            }
            if (this.progressable != null) {
                this.progressable.progress();
            }
            Thread.sleep(1000L);
        }
        ArrayList<PartETag> etags = new ArrayList<PartETag>();
        for (Map.Entry<Integer, List<MultiPartUploadFuture>> entry : this.partNumFutureMap.entrySet()) {
            List<MultiPartUploadFuture> allFutures = entry.getValue();
            MultiPartUploadFuture firstFuture = allFutures.get(0);
            etags.add(firstFuture.getFuture().get());
        }
        this.uploadPlan.getMultipartDispatcher().complete(this.getUploadCompletionEvent(etags));
    }

    private CompleteMultipartUploadEvent getUploadCompletionEvent(List<PartETag> etags) {
        return CompleteMultipartUploadEvent.builder().bucket(this.bucket).key(this.key).uploadId(this.uploadId).partETags(etags).totalLength(this.totalLength).extraUploadMetadata(this.uploadPlan.getExtraUploadMetadata()).build();
    }

    private void uploadSinglePartWithMultipartUpload() throws IOException {
        this.ensureMultipartUploadIsInitiated();
        this.currentOutput.close();
        MultipartUploadCallable multipartUploadCallable = new MultipartUploadCallable(this.partCount, this.currentPath, this.currentOutput.getMessageDigest().digest());
        PartETag etag = multipartUploadCallable.call();
        ImmutableList<PartETag> etags = ImmutableList.of(etag);
        this.uploadPlan.getMultipartDispatcher().complete(this.getUploadCompletionEvent(etags));
    }

    @Override
    public void close() throws IOException {
        logger.info("close closed:" + this.closed + " " + this.s3path);
        try {
            if (this.closed) {
                return;
            }
            this.closing = true;
            if (this.isMultipartUploadRequired()) {
                this.doMultiPartUpload();
            } else {
                this.uploadSinglePart();
            }
        }
        finally {
            this.temporaryDirectories.close();
            this.closed = true;
        }
    }

    private void doMultiPartUpload() throws IOException {
        try {
            if (this.partCount > 1) {
                this.uploadMultiParts();
            } else {
                this.uploadSinglePartWithMultipartUpload();
            }
        }
        catch (Exception e) {
            logger.info("completeMultipartUpload error for key: " + this.key, (Throwable)e);
            this.abort();
            throw new IOException("Error closing multipart upload", e);
        }
    }

    private boolean isMultipartUploadRequired() {
        return this.partCount > 1 || this.uploadPlan.getConstraint() == UploadConstraint.MULTIPART_UPLOAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        block9: {
            logger.info("abort closed:" + this.closed + " " + this.s3path);
            try {
                if (this.closed) {
                    return;
                }
                if (!this.multipartUploadInitiated) break block9;
                for (Map.Entry<Integer, List<MultiPartUploadFuture>> entry : this.partNumFutureMap.entrySet()) {
                    List<MultiPartUploadFuture> multiPartUploadFutures = entry.getValue();
                    for (MultiPartUploadFuture multipartUploadFuture : multiPartUploadFutures) {
                        Future<PartETag> future = multipartUploadFuture.getFuture();
                        future.cancel(true);
                    }
                }
                try {
                    this.abortUpload();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                this.temporaryDirectories.close();
            }
        }
        this.closed = true;
    }

    private void abortUpload() throws IOException {
        this.uploadPlan.getMultipartDispatcher().abort(AbortMultipartUploadEvent.builder().bucket(this.bucket).key(this.key).uploadId(this.uploadId).build());
    }

    private long capacityLeft() {
        return this.partSize - this.currentPartSize;
    }

    private void openNewPart() {
        try {
            this.currentPartSize = 0L;
            ++this.partCount;
            this.currentPath = this.temporaryFiles.create();
            this.currentOutput = new DigestOutputStream(new BufferedOutputStream(Files.newOutputStream(this.currentPath, StandardOpenOption.WRITE)), MessageDigest.getInstance("MD5"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temporary output stream.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error creating DigestOutputStream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndSchedulePart() throws IOException {
        this.ensureMultipartUploadIsInitiated();
        this.currentOutput.close();
        MultipartUploadCallable multipartUploadCallable = new MultipartUploadCallable(this.partCount, this.currentPath, this.currentOutput.getMessageDigest().digest());
        this.incompletePartNums.add(this.partCount);
        MultiPartUploadFuture multiPartUploadFuture = this.createMultiPartUploadFuture(Files.size(this.currentPath), multipartUploadCallable, this.partCount);
        if (this.incompletePartNums.contains(this.partCount)) {
            ArrayList<MultiPartUploadFuture> multiPartUploadFutures = new ArrayList<MultiPartUploadFuture>();
            multiPartUploadFutures.add(multiPartUploadFuture);
            Object object = this.partNumFutureMapHandle;
            synchronized (object) {
                this.partNumFutureMap.put(this.partCount, multiPartUploadFutures);
                this.partNumFutureMapHandle.notify();
            }
        }
        if (!this.closing) {
            this.openNewPart();
        }
    }

    private void ensureMultipartUploadIsInitiated() throws IOException {
        if (!this.multipartUploadInitiated) {
            S3ObjectRequestFactory s3ObjectRequestFactory = new S3ObjectRequestFactory(this.conf, this.serverSideEncryptionKmsKeyId);
            InitiateMultipartUploadRequest request = s3ObjectRequestFactory.newMultipartUploadRequest(this.bucket, this.key).withObjectMetadata(this.metadata);
            CannedAccessControlList acl = ConfigurationUtils.getAcl(this.conf);
            if (acl != null) {
                request.setCannedACL(acl);
            }
            InitiateMultipartUploadResult result = this.s3.initiateMultipartUpload(request);
            this.uploadId = result.getUploadId();
            this.multipartUploadInitiated = true;
        }
    }

    public long getPartSize() {
        return this.partSize;
    }

    public double getPartsCompletedThresholdPercent() {
        return this.partsCompletedThresholdPercent;
    }

    public double getFractionPartAvgCompletionTime() {
        return this.fractionPartAvgCompletionTime;
    }

    public int getMaxPartAttempts() {
        return this.maxPartAttempts;
    }

    private class MultipartUploadCallable
    implements Callable<PartETag> {
        private final int partNumber;
        private final Path partFilePath;
        private final String md5sum;
        private final String md5hex;
        private boolean shouldCallAbortOnCompletion;

        public MultipartUploadCallable(int partNumber, Path partFilePath, byte[] md5) {
            this.partNumber = partNumber;
            this.partFilePath = partFilePath;
            this.md5sum = this.encodeBase64String(md5);
            this.md5hex = new String(Hex.encodeHex(md5));
        }

        public MultipartUploadCallable(int partNumber, Path partFilePath, String md5, String md5hex) {
            this.partNumber = partNumber;
            this.partFilePath = partFilePath;
            this.md5sum = md5;
            this.md5hex = md5hex;
        }

        private String encodeBase64String(byte[] md5) {
            return Base64.encodeBase64String(md5).trim();
        }

        /*
         * Loose catch block
         */
        @Override
        public PartETag call() throws IOException {
            try {
                try (ProgressableResettableBufferedFileInputStream is = new ProgressableResettableBufferedFileInputStream(this.partFilePath.toFile(), MultipartUploadOutputStream.this.progressable);){
                    long fileSize = Files.size(this.partFilePath);
                    UploadPartRequest request = new UploadPartRequest().withBucketName(MultipartUploadOutputStream.this.bucket).withKey(MultipartUploadOutputStream.this.key).withUploadId(MultipartUploadOutputStream.this.uploadId).withInputStream(is).withPartNumber(this.partNumber).withPartSize(fileSize).withMD5Digest(this.md5sum);
                    long start = System.currentTimeMillis();
                    UploadPartResult result = MultipartUploadOutputStream.this.s3.uploadPart(request);
                    long uploadTimeMs = System.currentTimeMillis() - start;
                    logger.info("uploadPart: partNum {} of '{}' from local file '{}', {} bytes in {} ms, md5: {} md5hex: {}", new Object[]{this.partNumber, MultipartUploadOutputStream.this.s3path, this.partFilePath, fileSize, uploadTimeMs, this.md5sum, this.md5hex});
                    if (MultipartUploadOutputStream.this.closed && this.shouldCallAbortOnCompletion) {
                        MultipartUploadOutputStream.this.abortUpload();
                    }
                    PartETag partETag = result.getPartETag();
                    return partETag;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                MultipartUploadOutputStream.this.temporaryFiles.delete(this.partFilePath);
            }
        }

        public int getPartNumber() {
            return this.partNumber;
        }

        public Path getPartFilePath() {
            return this.partFilePath;
        }

        public String getMd5sum() {
            return this.md5sum;
        }

        public String getMd5hex() {
            return this.md5hex;
        }

        public void setShouldCallAbortOnCompletion(boolean shouldCallAbortOnCompletion) {
            this.shouldCallAbortOnCompletion = shouldCallAbortOnCompletion;
        }
    }

    private class MultipartUploadFutureCallBack
    implements FutureCallback<PartETag> {
        private final ListenableFuture<PartETag> future;
        private final int partNum;

        @Override
        public void onFailure(Throwable arg0) {
            if (this.future.isCancelled()) {
                logger.debug("Multipart Upload for part: " + this.partNum + " cancelled");
            } else {
                MultipartUploadOutputStream.this.incompletePartNums.remove(this.partNum);
                logger.debug("Removed " + this.partNum + " from incomplete partNum set because it failed");
                MultiPartUploadFuture multiPartUploadFuture = new MultiPartUploadFuture(0L, this.future, null);
                ArrayList<MultiPartUploadFuture> newMultipartUploadFutures = new ArrayList<MultiPartUploadFuture>();
                newMultipartUploadFutures.add(multiPartUploadFuture);
                MultipartUploadOutputStream.this.partNumFutureMap.put(this.partNum, newMultipartUploadFutures);
                logger.debug("Added just the failed future to the list of futures for partNum: " + this.partNum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(PartETag arg0) {
            DateTime endTime = DateTime.now();
            Object object = MultipartUploadOutputStream.this.partNumFutureMapHandle;
            synchronized (object) {
                try {
                    while (MultipartUploadOutputStream.this.partNumFutureMap.get(this.partNum) == null) {
                        MultipartUploadOutputStream.this.partNumFutureMapHandle.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread interrupted in multipart upload future callback's onSuccess", e);
                }
            }
            List multiPartUploadFutures = (List)MultipartUploadOutputStream.this.partNumFutureMap.get(this.partNum);
            logger.debug("Total spawned multipart upload futures for partNum: " + this.partNum + " are: " + multiPartUploadFutures.size());
            ArrayList<MultiPartUploadFuture> newMultipartUploadFutures = null;
            for (MultiPartUploadFuture multiPartUploadFuture : multiPartUploadFutures) {
                if (multiPartUploadFuture.getFuture().isDone()) {
                    multiPartUploadFuture.setEndTime(endTime);
                    newMultipartUploadFutures = new ArrayList<MultiPartUploadFuture>();
                    newMultipartUploadFutures.add(multiPartUploadFuture);
                    continue;
                }
                logger.debug("Cancelling future for partNum: " + this.partNum + " running for: " + (endTime.getMillis() - multiPartUploadFuture.getStartTime().getMillis()) / 1000L + " s");
                multiPartUploadFuture.getFuture().cancel(true);
                multiPartUploadFuture.getMultipartUploadCallable().setShouldCallAbortOnCompletion(true);
            }
            if (newMultipartUploadFutures != null) {
                MultipartUploadOutputStream.this.partNumFutureMap.put(this.partNum, newMultipartUploadFutures);
            }
            logger.debug("Going to remove " + this.partNum + " from the incomplete part num set");
            MultipartUploadOutputStream.this.incompletePartNums.remove(this.partNum);
        }

        public MultipartUploadFutureCallBack(ListenableFuture<PartETag> future, int partNum) {
            this.future = future;
            this.partNum = partNum;
        }
    }

    private class MultiPartUploadFuture {
        private final long partSize;
        private Future<PartETag> future;
        private MultipartUploadCallable multipartUploadCallable;
        private DateTime startTime;
        private DateTime endTime;

        public MultiPartUploadFuture(long partSize, Future<PartETag> future, MultipartUploadCallable multiPartUploadCallable) {
            this.partSize = partSize;
            this.future = future;
            this.multipartUploadCallable = multiPartUploadCallable;
        }

        public long getPartSize() {
            return this.partSize;
        }

        public Future<PartETag> getFuture() {
            return this.future;
        }

        public MultipartUploadCallable getMultipartUploadCallable() {
            return this.multipartUploadCallable;
        }

        public DateTime getStartTime() {
            return this.startTime;
        }

        public void setStartTime(DateTime startTime) {
            this.startTime = startTime;
        }

        public DateTime getEndTime() {
            return this.endTime;
        }

        public void setEndTime(DateTime endTime) {
            this.endTime = endTime;
        }
    }
}

