/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.s3.ContentLengthSupplier;
import com.amazon.ws.emr.hadoop.fs.s3.GetObjectInputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.MultipartCopyManager;
import com.amazon.ws.emr.hadoop.fs.s3.S3FSInputStream;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.S3SelectInputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.s3n.NativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.PartialListing;
import com.amazon.ws.emr.hadoop.fs.s3n.ProgressableResettableBufferedFileInputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectId;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.Cache;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.CacheBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.codec.binary.Base64;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    private static final Logger logger = LoggerFactory.getLogger(Jets3tNativeFileSystemStore.class);
    private static final int MAX_DISPLAY_KEYS = 3;
    private static final int MAX_CACHE_SIZE = 1000;
    protected Configuration conf;
    Cache<String, FileMetadata> fileMetadataCache = null;
    private String serverSideEncryptionAlgorithm = null;
    private String serverSideEncryptionKmsKeyId = null;
    private S3ObjectRequestFactory s3ObjectRequestFactory = null;
    private AmazonS3Lite s3;
    private ListeningExecutorService listeningExecutorService;
    private String bucket;

    public Jets3tNativeFileSystemStore(AmazonS3Lite s3, ListeningExecutorService listeningExecutorService) {
        this.s3 = s3;
        this.listeningExecutorService = listeningExecutorService;
    }

    private static List<String> getErrorKeys(MultiObjectDeleteException mode) {
        return Lists.transform(mode.getErrors(), error -> error.getKey());
    }

    private static String formatBatchOperationErrorMessage(Class<? extends Exception> exceptionType, List<String> errorKeys) {
        int numDisplayErrorKeys = Math.min(3, errorKeys.size());
        List<String> firstKErrorKeys = errorKeys.subList(0, numDisplayErrorKeys);
        StringBuilder sb = new StringBuilder(String.format("%s thrown with %d keys in error: ", exceptionType.getSimpleName(), errorKeys.size()));
        Joiner.on(", ").appendTo(sb, (Iterable<?>)firstKErrorKeys);
        if (numDisplayErrorKeys > errorKeys.size()) {
            sb.append(String.format(" and %d other key(s)", errorKeys.size() - numDisplayErrorKeys));
        }
        return sb.toString();
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        this.bucket = S3UriUtils.uriToBucket(uri);
        this.conf = conf;
        if (ConfigurationUtils.isCreateBucketEnabled(conf)) {
            this.ensureBucketExists(this.bucket, conf);
        }
        long cacheExpirationSeconds = ConfigurationUtils.getMetadataCacheExpirationSeconds(conf);
        this.fileMetadataCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(cacheExpirationSeconds, TimeUnit.SECONDS).build();
        if (ConfigurationUtils.isServerSideEncryptionEnabled(conf)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(conf);
            this.serverSideEncryptionKmsKeyId = ConfigurationUtils.getServerSideEncryptionKmsKeyId(conf);
        }
        this.s3ObjectRequestFactory = new S3ObjectRequestFactory(conf, this.serverSideEncryptionKmsKeyId);
    }

    private void ensureBucketExists(String bucket, Configuration conf) {
        if (!this.s3.doesBucketExist(bucket)) {
            this.s3.createBucket(bucket, ConfigurationUtils.getS3BucketCreateRegion(conf));
        }
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public void invalidateCache(String key) {
        if (this.fileMetadataCache != null) {
            this.fileMetadataCache.invalidate(key);
        }
    }

    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        this.storeFile(key, file, md5Hash, null);
    }

    @Override
    public void storeFile(String key, File file, byte[] md5Hash, Progressable progressable) throws IOException {
        ObjectMetadata objectMetadata = this.buildObjectMetadata(file.length(), md5Hash);
        try (ProgressableResettableBufferedFileInputStream inputStream = new ProgressableResettableBufferedFileInputStream(file, progressable);){
            PutObjectRequest request = this.buildPutObjectRequest(key, inputStream, objectMetadata);
            logger.debug("s3.putObject {} {} {}", new Object[]{this.bucket, key, file.length()});
            this.s3.putObject(request);
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.conf, this.s3, this.bucket, key);
            this.invalidateCache(key);
        }
    }

    @Override
    public void storeEmptyFile(String key) throws IOException {
        ObjectMetadata objectMetadata = this.buildObjectMetadata(0L, null);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);){
            PutObjectRequest putObjectRequest = this.buildPutObjectRequest(key, inputStream, objectMetadata);
            logger.debug("s3.putObject {} {}", (Object)this.bucket, (Object)key);
            this.s3.putObject(putObjectRequest);
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.conf, this.s3, this.bucket, key);
            this.invalidateCache(key);
        }
    }

    private ObjectMetadata buildObjectMetadata(long contentLength, byte[] md5Hash) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("binary/octet-stream");
        objectMetadata.setContentLength(contentLength);
        if (md5Hash != null && !ConfigurationUtils.isClientSideEncryptionEnabled(this.conf)) {
            objectMetadata.setContentMD5(new String(Base64.encodeBase64(md5Hash)));
        }
        if (!Strings.isNullOrEmpty(this.serverSideEncryptionAlgorithm)) {
            objectMetadata.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        return objectMetadata;
    }

    private PutObjectRequest buildPutObjectRequest(String key, InputStream inputStream, ObjectMetadata objectMetadata) {
        PutObjectRequest request = this.s3ObjectRequestFactory.newPutObjectRequest(this.bucket, key, inputStream, objectMetadata);
        CannedAccessControlList acl = ConfigurationUtils.getAcl(this.conf);
        if (acl != null) {
            request.setCannedAcl(acl);
        }
        return request;
    }

    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        try {
            return this.getFileMetadataFromCacheOrS3(key);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                if (e.getStatusCode() == 403) {
                    logger.debug("Cannot get metadata for {} due to {}", (Object)key, (Object)e.getMessage());
                }
                return null;
            }
            throw e;
        }
    }

    @Override
    public FSInputStream open(String key, long contentLength, @Nullable FileSystem.Statistics statistics, @Nullable Configuration selectOptions) throws IOException {
        boolean lazyOpen = ConfigurationUtils.isLazyInitializeConnection(this.conf) && selectOptions == null;
        return new S3FSInputStream(this.bucket, key, this.getContentLengthSupplier(), this.getInputStreamFactory(selectOptions), this.conf, statistics, null, false, lazyOpen, contentLength);
    }

    private ContentLengthSupplier getContentLengthSupplier() {
        return (givenBucket, givenKey) -> {
            Preconditions.checkArgument(givenBucket.equals(this.bucket));
            FileMetadata metadata = this.getFileMetadataFromCacheOrS3(givenKey);
            return metadata.getLength();
        };
    }

    private InputStreamWithInfoFactory getInputStreamFactory(@Nullable Configuration selectOptions) {
        return selectOptions == null ? GetObjectInputStreamWithInfoFactory.builder().s3(this.s3).build() : new S3SelectInputStreamWithInfoFactory(this.s3, selectOptions);
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            FileMetadata metadata = this.retrieveMetadata(key);
            if (metadata == null) {
                throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
            }
            return this.s3.getObject(this.s3ObjectRequestFactory.newGetObjectRequest(this.bucket, key, byteRangeStart, metadata.getLength())).getObjectContent();
        }
        catch (AmazonServiceException ase) {
            throw this.handleAmazonServiceException(key, ase);
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        try {
            return this.s3.getObject(this.bucket, key).getObjectContent();
        }
        catch (AmazonServiceException ase) {
            throw this.handleAmazonServiceException(key, ase);
        }
    }

    @Override
    public PartialListing list(String prefix, int maxKeys, String startAfter, String continuationToken, boolean recurse) throws IOException {
        ListObjectsV2Result listing;
        String delimiter;
        String string = delimiter = recurse ? null : "/";
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        String encodingType = ConfigurationUtils.getListObjectsEncodingType(this.conf);
        try {
            listing = this.s3.listObjectsV2(new ListObjectsV2Request().withBucketName(this.bucket).withPrefix(prefix).withDelimiter(delimiter).withMaxKeys(maxKeys).withStartAfter(startAfter).withContinuationToken(continuationToken).withEncodingType(encodingType));
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        PartialListing output = new PartialListing(startAfter, continuationToken);
        output.addFiles(listing.getObjectSummaries());
        output.addDirs(listing.getCommonPrefixes());
        output.setNextContinuationToken(listing.getNextContinuationToken());
        return output;
    }

    @Override
    public void delete(String key) throws IOException {
        try {
            logger.debug("s3.deleteObject {} {}", (Object)this.bucket, (Object)key);
            this.s3.deleteObject(this.bucket, key);
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.conf, this.s3, this.bucket, key);
            this.invalidateCache(key);
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(key, e);
        }
    }

    @Override
    public void deleteAll(List<String> keys) throws IOException {
        if (keys.size() == 1) {
            this.delete(keys.get(0));
            return;
        }
        keys = this.includeInstructionsFilesIfNeeded(keys);
        List<List<String>> keyBatches = Lists.partition(keys, ConfigurationUtils.getS3DeleteMaxBatchSize(this.conf));
        Exception firstException = null;
        int numExceptions = 0;
        for (List<String> keyBatch : keyBatches) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("s3.deleteObjects for {} object(s) in bucket {}", (Object)keyBatch.size(), (Object)this.bucket);
                    for (String key2 : keyBatch) {
                        logger.debug("s3.deleteObjects batch contains key {}", (Object)key2);
                    }
                }
                List<DeleteObjectsRequest.KeyVersion> keyVersionBatch = Lists.transform(keyBatch, key -> new DeleteObjectsRequest.KeyVersion((String)key));
                this.s3.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keyVersionBatch));
                this.fileMetadataCache.invalidateAll(keyBatch);
            }
            catch (MultiObjectDeleteException e) {
                String message = Jets3tNativeFileSystemStore.formatBatchOperationErrorMessage(e.getClass(), Jets3tNativeFileSystemStore.getErrorKeys(e));
                if (firstException == null) {
                    firstException = new IOException(message, e);
                }
                ++numExceptions;
                logger.error(message, (Throwable)e);
            }
            catch (AmazonServiceException e) {
                if (firstException == null) {
                    firstException = e;
                }
                ++numExceptions;
                logger.error("Exception thrown from single batch delete", (Throwable)e);
            }
        }
        if (firstException != null) {
            throw new IOException(String.format("%d exceptions thrown from %d batch deletes", numExceptions, keyBatches.size()), firstException);
        }
    }

    private List<String> includeInstructionsFilesIfNeeded(List<String> keys) {
        if (CSEUtils.shouldDeletePreviousInstructionFiles(this.conf)) {
            keys = Lists.newArrayList(Iterables.concat(keys, Lists.transform(keys, key -> new S3ObjectId(this.bucket, (String)key).instructionFileId().getKey())));
        }
        return keys;
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        try {
            this.createMultipartCopyManager(srcKey, dstKey).copy();
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(srcKey, e);
        }
    }

    @Override
    public List<Callable<String>> createCopyCallables(String srcKey, String dstKey) throws IOException {
        try {
            return this.createMultipartCopyManager(srcKey, dstKey).createCopyCallables();
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(srcKey, e);
        }
    }

    private MultipartCopyManager createMultipartCopyManager(String srcKey, String dstKey) {
        return new MultipartCopyManager.Builder().withS3(this.s3).withExecutorService(this.listeningExecutorService).withSrcBucketName(this.bucket).withSrcKey(srcKey).withDstBucketName(this.bucket).withDstKey(dstKey).withAcl(ConfigurationUtils.getAcl(this.conf)).withServerSideEncryption(this.serverSideEncryptionAlgorithm).withServerSideKmsKeyId(this.serverSideEncryptionKmsKeyId).withConf(this.conf).build();
    }

    private IOException handleAmazonServiceException(String key, AmazonServiceException ase) throws IOException {
        if ("NoSuchKey".equals(ase.getErrorCode())) {
            return new FileNotFoundException("Key '" + key + "' does not exist in S3");
        }
        throw new IOException(ase);
    }

    private FileMetadata getFileMetadataFromCacheOrS3(String key) {
        FileMetadata fileMetadata = this.fileMetadataCache.getIfPresent(key);
        if (fileMetadata != null) {
            return fileMetadata;
        }
        ObjectMetadata metadata = this.s3.getObjectMetadata(this.bucket, key);
        long plaintextLength = CSEUtils.getPlaintextLength(this.s3, this.bucket, key, metadata, this.conf);
        logger.debug("plaintext content length for key {} is: {}", (Object)key, (Object)plaintextLength);
        fileMetadata = new FileMetadata(key, plaintextLength, metadata.getLastModified().getTime());
        this.fileMetadataCache.put(key, fileMetadata);
        return fileMetadata;
    }
}

