/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FileMetadata {
    private final String key;
    private final long length;
    private final long lastModified;

    public FileMetadata(String key, long length, long lastModified) {
        this.key = key;
        this.length = length;
        this.lastModified = lastModified;
    }

    public String getKey() {
        return this.key;
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileMetadata)) {
            return false;
        }
        FileMetadata other = (FileMetadata)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        return this.getLastModified() == other.getLastModified();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        long $lastModified = this.getLastModified();
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        return result;
    }

    public String toString() {
        return "FileMetadata(key=" + this.getKey() + ", length=" + this.getLength() + ", lastModified=" + this.getLastModified() + ")";
    }
}

