/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3n;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.function.LongSupplier;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public final class BasicFileStatusFactory
implements FileStatusFactory {
    private static final long DIRECTORY_LENGTH = 0L;
    private static final long DIRECTORY_BLOCK_SIZE = 0L;
    private static final long DIRECTORY_MODIFICATION_TIME = 0L;
    private static final long ACCESS_TIME = 0L;
    private static final int BLOCK_REPLICATION = 1;
    private static final FsPermission PERMISSION = null;
    @NonNull
    private final FileSystemOwner fileSystemOwner;
    @NonNull
    private final UnaryOperator<Path> pathQualifier;
    @NonNull
    private final LongSupplier blockSizeSupplier;

    @Override
    public FileStatus newDirectory(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new FileStatus(0L, true, 1, 0L, 0L, 0L, PERMISSION, this.fileSystemOwner.getFullUserName(), this.fileSystemOwner.getGroup(), (Path)this.pathQualifier.apply(path));
    }

    @Override
    public FileStatus newFile(@NonNull Path path, long length, long modificationTime) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Preconditions.checkArgument(length >= 0L, "Length must not be negative");
        return new FileStatus(length, false, 1, this.blockSizeSupplier.getAsLong(), modificationTime, 0L, PERMISSION, this.fileSystemOwner.getFullUserName(), this.fileSystemOwner.getGroup(), (Path)this.pathQualifier.apply(path));
    }

    BasicFileStatusFactory(@NonNull FileSystemOwner fileSystemOwner, @NonNull UnaryOperator<Path> pathQualifier, @NonNull LongSupplier blockSizeSupplier) {
        if (fileSystemOwner == null) {
            throw new NullPointerException("fileSystemOwner is marked non-null but is null");
        }
        if (pathQualifier == null) {
            throw new NullPointerException("pathQualifier is marked non-null but is null");
        }
        if (blockSizeSupplier == null) {
            throw new NullPointerException("blockSizeSupplier is marked non-null but is null");
        }
        this.fileSystemOwner = fileSystemOwner;
        this.pathQualifier = pathQualifier;
        this.blockSizeSupplier = blockSizeSupplier;
    }

    public static BasicFileStatusFactoryBuilder builder() {
        return new BasicFileStatusFactoryBuilder();
    }

    public static class BasicFileStatusFactoryBuilder {
        private FileSystemOwner fileSystemOwner;
        private UnaryOperator<Path> pathQualifier;
        private LongSupplier blockSizeSupplier;

        BasicFileStatusFactoryBuilder() {
        }

        public BasicFileStatusFactoryBuilder fileSystemOwner(@NonNull FileSystemOwner fileSystemOwner) {
            if (fileSystemOwner == null) {
                throw new NullPointerException("fileSystemOwner is marked non-null but is null");
            }
            this.fileSystemOwner = fileSystemOwner;
            return this;
        }

        public BasicFileStatusFactoryBuilder pathQualifier(@NonNull UnaryOperator<Path> pathQualifier) {
            if (pathQualifier == null) {
                throw new NullPointerException("pathQualifier is marked non-null but is null");
            }
            this.pathQualifier = pathQualifier;
            return this;
        }

        public BasicFileStatusFactoryBuilder blockSizeSupplier(@NonNull LongSupplier blockSizeSupplier) {
            if (blockSizeSupplier == null) {
                throw new NullPointerException("blockSizeSupplier is marked non-null but is null");
            }
            this.blockSizeSupplier = blockSizeSupplier;
            return this;
        }

        public BasicFileStatusFactory build() {
            return new BasicFileStatusFactory(this.fileSystemOwner, this.pathQualifier, this.blockSizeSupplier);
        }

        public String toString() {
            return "BasicFileStatusFactory.BasicFileStatusFactoryBuilder(fileSystemOwner=" + this.fileSystemOwner + ", pathQualifier=" + this.pathQualifier + ", blockSizeSupplier=" + this.blockSizeSupplier + ")";
        }
    }
}

