/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.plan;

import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.ConditionalUploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

final class UploadPlannerChain
implements UploadPlanner {
    private final List<ConditionalUploadPlanner> conditionalPlanners;
    private final UploadPlanner fallbackPlanner;

    private UploadPlannerChain(@NonNull List<ConditionalUploadPlanner> conditionalPlanners, @NonNull UploadPlanner fallbackPlanner) {
        if (conditionalPlanners == null) {
            throw new NullPointerException("conditionalPlanners is marked non-null but is null");
        }
        if (fallbackPlanner == null) {
            throw new NullPointerException("fallbackPlanner is marked non-null but is null");
        }
        UploadPlannerChain.checkFallbackPlanner(fallbackPlanner);
        this.conditionalPlanners = conditionalPlanners;
        this.fallbackPlanner = fallbackPlanner;
    }

    @Override
    public UploadPlan plan(Path path, boolean overwrite) throws IOException {
        return this.getPlanner(path).plan(path, overwrite);
    }

    private UploadPlanner getPlanner(Path path) {
        for (ConditionalUploadPlanner conditionalPlanner : this.conditionalPlanners) {
            if (!conditionalPlanner.canPlan(path)) continue;
            return conditionalPlanner;
        }
        return this.fallbackPlanner;
    }

    private static void checkFallbackPlanner(@NonNull UploadPlanner fallbackPlanner) {
        if (fallbackPlanner == null) {
            throw new NullPointerException("fallbackPlanner is marked non-null but is null");
        }
        Preconditions.checkArgument(!(fallbackPlanner instanceof ConditionalUploadPlanner), "Fallback planner must not be a %s", ConditionalUploadPlanner.class.getSimpleName());
    }

    public static UploadPlannerChainBuilder builder() {
        return new UploadPlannerChainBuilder();
    }

    public static class UploadPlannerChainBuilder {
        private ArrayList<ConditionalUploadPlanner> conditionalPlanners;
        private UploadPlanner fallbackPlanner;

        UploadPlannerChainBuilder() {
        }

        public UploadPlannerChainBuilder conditionalPlanner(ConditionalUploadPlanner conditionalPlanner) {
            if (this.conditionalPlanners == null) {
                this.conditionalPlanners = new ArrayList();
            }
            this.conditionalPlanners.add(conditionalPlanner);
            return this;
        }

        public UploadPlannerChainBuilder conditionalPlanners(Collection<? extends ConditionalUploadPlanner> conditionalPlanners) {
            if (conditionalPlanners == null) {
                throw new NullPointerException("conditionalPlanners cannot be null");
            }
            if (this.conditionalPlanners == null) {
                this.conditionalPlanners = new ArrayList();
            }
            this.conditionalPlanners.addAll(conditionalPlanners);
            return this;
        }

        public UploadPlannerChainBuilder clearConditionalPlanners() {
            if (this.conditionalPlanners != null) {
                this.conditionalPlanners.clear();
            }
            return this;
        }

        public UploadPlannerChainBuilder fallbackPlanner(@NonNull UploadPlanner fallbackPlanner) {
            if (fallbackPlanner == null) {
                throw new NullPointerException("fallbackPlanner is marked non-null but is null");
            }
            this.fallbackPlanner = fallbackPlanner;
            return this;
        }

        public UploadPlannerChain build() {
            List<Object> conditionalPlanners;
            switch (this.conditionalPlanners == null ? 0 : this.conditionalPlanners.size()) {
                case 0: {
                    conditionalPlanners = Collections.emptyList();
                    break;
                }
                case 1: {
                    conditionalPlanners = Collections.singletonList(this.conditionalPlanners.get(0));
                    break;
                }
                default: {
                    conditionalPlanners = Collections.unmodifiableList(new ArrayList<ConditionalUploadPlanner>(this.conditionalPlanners));
                }
            }
            return new UploadPlannerChain(conditionalPlanners, this.fallbackPlanner);
        }

        public String toString() {
            return "UploadPlannerChain.UploadPlannerChainBuilder(conditionalPlanners=" + this.conditionalPlanners + ", fallbackPlanner=" + this.fallbackPlanner + ")";
        }
    }
}

