/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.plan;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.SinglePartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import lombok.NonNull;

public final class UploadPlan {
    private final String bucket;
    private final String key;
    private final UploadConstraint constraint;
    private final SinglePartUploadDispatcher singlePartDispatcher;
    private final MultipartUploadDispatcher multipartDispatcher;
    private final ExtraUploadMetadata extraUploadMetadata;

    private UploadPlan(@NonNull String bucket, @NonNull String key, UploadConstraint constraint, SinglePartUploadDispatcher singlePartDispatcher, MultipartUploadDispatcher multipartDispatcher, @NonNull ExtraUploadMetadata extraUploadMetadata) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (extraUploadMetadata == null) {
            throw new NullPointerException("extraUploadMetadata is marked non-null but is null");
        }
        this.bucket = bucket;
        this.key = key;
        this.constraint = constraint;
        this.singlePartDispatcher = singlePartDispatcher;
        this.multipartDispatcher = multipartDispatcher;
        this.extraUploadMetadata = extraUploadMetadata;
        if (constraint == null || constraint == UploadConstraint.SINGLE_PART_UPLOAD) {
            Preconditions.checkNotNull(singlePartDispatcher, "single part upload dispatcher is required");
            if (constraint == UploadConstraint.SINGLE_PART_UPLOAD) {
                Preconditions.checkArgument(multipartDispatcher == null, "multipart upload dispatcher must not be specified if constrained to single part uploads");
            }
        }
        if (constraint == null || constraint == UploadConstraint.MULTIPART_UPLOAD) {
            Preconditions.checkNotNull(multipartDispatcher, "multipart upload dispatcher is required");
            if (constraint == UploadConstraint.MULTIPART_UPLOAD) {
                Preconditions.checkArgument(singlePartDispatcher == null, "single part upload dispatcher must not be specified if constrained to multipart uploads");
            }
        }
    }

    public static UploadPlanBuilder builder() {
        return new UploadPlanBuilder();
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public UploadConstraint getConstraint() {
        return this.constraint;
    }

    public SinglePartUploadDispatcher getSinglePartDispatcher() {
        return this.singlePartDispatcher;
    }

    public MultipartUploadDispatcher getMultipartDispatcher() {
        return this.multipartDispatcher;
    }

    public ExtraUploadMetadata getExtraUploadMetadata() {
        return this.extraUploadMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadPlan)) {
            return false;
        }
        UploadPlan other = (UploadPlan)o;
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        UploadConstraint this$constraint = this.getConstraint();
        UploadConstraint other$constraint = other.getConstraint();
        if (this$constraint == null ? other$constraint != null : !((Object)((Object)this$constraint)).equals((Object)other$constraint)) {
            return false;
        }
        SinglePartUploadDispatcher this$singlePartDispatcher = this.getSinglePartDispatcher();
        SinglePartUploadDispatcher other$singlePartDispatcher = other.getSinglePartDispatcher();
        if (this$singlePartDispatcher == null ? other$singlePartDispatcher != null : !this$singlePartDispatcher.equals(other$singlePartDispatcher)) {
            return false;
        }
        MultipartUploadDispatcher this$multipartDispatcher = this.getMultipartDispatcher();
        MultipartUploadDispatcher other$multipartDispatcher = other.getMultipartDispatcher();
        if (this$multipartDispatcher == null ? other$multipartDispatcher != null : !this$multipartDispatcher.equals(other$multipartDispatcher)) {
            return false;
        }
        ExtraUploadMetadata this$extraUploadMetadata = this.getExtraUploadMetadata();
        ExtraUploadMetadata other$extraUploadMetadata = other.getExtraUploadMetadata();
        return !(this$extraUploadMetadata == null ? other$extraUploadMetadata != null : !((Object)this$extraUploadMetadata).equals(other$extraUploadMetadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        UploadConstraint $constraint = this.getConstraint();
        result = result * 59 + ($constraint == null ? 43 : ((Object)((Object)$constraint)).hashCode());
        SinglePartUploadDispatcher $singlePartDispatcher = this.getSinglePartDispatcher();
        result = result * 59 + ($singlePartDispatcher == null ? 43 : $singlePartDispatcher.hashCode());
        MultipartUploadDispatcher $multipartDispatcher = this.getMultipartDispatcher();
        result = result * 59 + ($multipartDispatcher == null ? 43 : $multipartDispatcher.hashCode());
        ExtraUploadMetadata $extraUploadMetadata = this.getExtraUploadMetadata();
        result = result * 59 + ($extraUploadMetadata == null ? 43 : ((Object)$extraUploadMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "UploadPlan(bucket=" + this.getBucket() + ", key=" + this.getKey() + ", constraint=" + (Object)((Object)this.getConstraint()) + ", singlePartDispatcher=" + this.getSinglePartDispatcher() + ", multipartDispatcher=" + this.getMultipartDispatcher() + ", extraUploadMetadata=" + this.getExtraUploadMetadata() + ")";
    }

    public static class UploadPlanBuilder {
        private String bucket;
        private String key;
        private UploadConstraint constraint;
        private SinglePartUploadDispatcher singlePartDispatcher;
        private MultipartUploadDispatcher multipartDispatcher;
        private ExtraUploadMetadata extraUploadMetadata;

        UploadPlanBuilder() {
        }

        public UploadPlanBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public UploadPlanBuilder key(String key) {
            this.key = key;
            return this;
        }

        public UploadPlanBuilder constraint(UploadConstraint constraint) {
            this.constraint = constraint;
            return this;
        }

        public UploadPlanBuilder singlePartDispatcher(SinglePartUploadDispatcher singlePartDispatcher) {
            this.singlePartDispatcher = singlePartDispatcher;
            return this;
        }

        public UploadPlanBuilder multipartDispatcher(MultipartUploadDispatcher multipartDispatcher) {
            this.multipartDispatcher = multipartDispatcher;
            return this;
        }

        public UploadPlanBuilder extraUploadMetadata(ExtraUploadMetadata extraUploadMetadata) {
            this.extraUploadMetadata = extraUploadMetadata;
            return this;
        }

        public UploadPlan build() {
            return new UploadPlan(this.bucket, this.key, this.constraint, this.singlePartDispatcher, this.multipartDispatcher, this.extraUploadMetadata);
        }

        public String toString() {
            return "UploadPlan.UploadPlanBuilder(bucket=" + this.bucket + ", key=" + this.key + ", constraint=" + (Object)((Object)this.constraint) + ", singlePartDispatcher=" + this.singlePartDispatcher + ", multipartDispatcher=" + this.multipartDispatcher + ", extraUploadMetadata=" + this.extraUploadMetadata + ")";
        }
    }
}

