/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.plan;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.StagingMultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.ConditionalUploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStore;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPath;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.IOException;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.staging.UnsupportedStagingDirectoryOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StagingUploadPlanner
implements ConditionalUploadPlanner {
    private static final Logger logger = LoggerFactory.getLogger(StagingUploadPlanner.class);
    private static final String DELIMITER = "/";
    @NonNull
    private final String bucket;
    @NonNull
    private final Configuration conf;
    @NonNull
    private final StagingPathConverter stagingPathConverter;
    @NonNull
    private final StagingMetadataStore stagingMetadataStore;
    @NonNull
    private final MultipartUploadDispatcher multipartDispatcher;

    @Override
    public boolean canPlan(Path path) {
        return this.stagingPathConverter.isStagingPath(path);
    }

    @Override
    public UploadPlan plan(Path path, boolean overwrite) throws IOException {
        this.checkMultipartUploadsEnabled();
        StagingPath stagingPath = this.stagingPathConverter.toStagingPath(path);
        StagingUploadPlanner.checkNotStagingRoot(stagingPath);
        StagedFileHandle fileHandle = this.stagingMetadataStore.createFile(stagingPath, overwrite);
        String key = this.getOutputKey(stagingPath);
        logger.info("Creating a new staged file '{}' with destination key '{}'", (Object)path, (Object)key);
        return UploadPlan.builder().bucket(this.bucket).key(key).constraint(UploadConstraint.MULTIPART_UPLOAD).multipartDispatcher(new StagingMultipartUploadDispatcher(fileHandle, this.multipartDispatcher)).extraUploadMetadata(ExtraUploadMetadata.empty()).build();
    }

    private String getOutputKey(StagingPath stagingPath) {
        return S3UriUtils.pathToKey(new Path(stagingPath.getRoot().getOutputPath(), Joiner.on(DELIMITER).join(stagingPath.getComponents())));
    }

    private void checkMultipartUploadsEnabled() throws IOException {
        if (!ConfigurationUtils.isMultipartUploadEnabled(this.conf)) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Multipart uploads (%s) must be enabled in order to create files under a staging directory", "fs.s3n.multipart.uploads.enabled"));
        }
    }

    private static void checkNotStagingRoot(StagingPath stagingPath) throws IOException {
        if (stagingPath.isRoot()) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Cannot create files at paths matching a staging directory root: %s", stagingPath));
        }
    }

    StagingUploadPlanner(@NonNull String bucket, @NonNull Configuration conf, @NonNull StagingPathConverter stagingPathConverter, @NonNull StagingMetadataStore stagingMetadataStore, @NonNull MultipartUploadDispatcher multipartDispatcher) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        if (stagingPathConverter == null) {
            throw new NullPointerException("stagingPathConverter is marked non-null but is null");
        }
        if (stagingMetadataStore == null) {
            throw new NullPointerException("stagingMetadataStore is marked non-null but is null");
        }
        if (multipartDispatcher == null) {
            throw new NullPointerException("multipartDispatcher is marked non-null but is null");
        }
        this.bucket = bucket;
        this.conf = conf;
        this.stagingPathConverter = stagingPathConverter;
        this.stagingMetadataStore = stagingMetadataStore;
        this.multipartDispatcher = multipartDispatcher;
    }

    public static StagingUploadPlannerBuilder builder() {
        return new StagingUploadPlannerBuilder();
    }

    public static class StagingUploadPlannerBuilder {
        private String bucket;
        private Configuration conf;
        private StagingPathConverter stagingPathConverter;
        private StagingMetadataStore stagingMetadataStore;
        private MultipartUploadDispatcher multipartDispatcher;

        StagingUploadPlannerBuilder() {
        }

        public StagingUploadPlannerBuilder bucket(@NonNull String bucket) {
            if (bucket == null) {
                throw new NullPointerException("bucket is marked non-null but is null");
            }
            this.bucket = bucket;
            return this;
        }

        public StagingUploadPlannerBuilder conf(@NonNull Configuration conf) {
            if (conf == null) {
                throw new NullPointerException("conf is marked non-null but is null");
            }
            this.conf = conf;
            return this;
        }

        public StagingUploadPlannerBuilder stagingPathConverter(@NonNull StagingPathConverter stagingPathConverter) {
            if (stagingPathConverter == null) {
                throw new NullPointerException("stagingPathConverter is marked non-null but is null");
            }
            this.stagingPathConverter = stagingPathConverter;
            return this;
        }

        public StagingUploadPlannerBuilder stagingMetadataStore(@NonNull StagingMetadataStore stagingMetadataStore) {
            if (stagingMetadataStore == null) {
                throw new NullPointerException("stagingMetadataStore is marked non-null but is null");
            }
            this.stagingMetadataStore = stagingMetadataStore;
            return this;
        }

        public StagingUploadPlannerBuilder multipartDispatcher(@NonNull MultipartUploadDispatcher multipartDispatcher) {
            if (multipartDispatcher == null) {
                throw new NullPointerException("multipartDispatcher is marked non-null but is null");
            }
            this.multipartDispatcher = multipartDispatcher;
            return this;
        }

        public StagingUploadPlanner build() {
            return new StagingUploadPlanner(this.bucket, this.conf, this.stagingPathConverter, this.stagingMetadataStore, this.multipartDispatcher);
        }

        public String toString() {
            return "StagingUploadPlanner.StagingUploadPlannerBuilder(bucket=" + this.bucket + ", conf=" + this.conf + ", stagingPathConverter=" + this.stagingPathConverter + ", stagingMetadataStore=" + this.stagingMetadataStore + ", multipartDispatcher=" + this.multipartDispatcher + ")";
        }
    }
}

