/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.plan;

import com.amazon.ws.emr.hadoop.fs.consistency.FileStatusExt;
import com.amazon.ws.emr.hadoop.fs.consistency.concurrent.ConcurrencyToken;
import com.amazon.ws.emr.hadoop.fs.consistency.exception.FileDeletedInMetadataNotFoundException;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanTemplate;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import com.amazon.ws.emr.hadoop.fs.util.io.IOFunction;
import java.io.FileNotFoundException;
import java.io.IOException;
import lombok.NonNull;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;

final class ConsistentViewUploadPlanner
implements UploadPlanner {
    @NonNull
    private final UploadPlanTemplate template;
    @NonNull
    private final IOFunction<Path, FileStatusExt> statusGetter;

    @Override
    public UploadPlan plan(Path path, boolean overwrite) throws IOException {
        ConcurrencyToken concurrencyToken = this.checkPreexistence(path, overwrite);
        return UploadPlan.builder().bucket(this.template.getBucket()).key(S3UriUtils.pathToKey(path)).singlePartDispatcher(this.template.getSinglePartDispatcher()).multipartDispatcher(this.template.getMultipartDispatcher()).extraUploadMetadata(new ExtraUploadMetadata(concurrencyToken)).build();
    }

    private ConcurrencyToken checkPreexistence(Path path, boolean overwrite) throws IOException {
        try {
            FileStatusExt status = this.statusGetter.apply(path);
            if (status.isDirectory()) {
                throw new IOException("Path already exists as a directory: " + path);
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException("Path already exists as a file: " + path);
            }
            return ConcurrencyToken.of(status.getEntity());
        }
        catch (FileDeletedInMetadataNotFoundException e) {
            return ConcurrencyToken.of(e.getEntity());
        }
        catch (FileNotFoundException e) {
            return ConcurrencyToken.ofNonexistentEntity();
        }
    }

    public ConsistentViewUploadPlanner(@NonNull UploadPlanTemplate template, @NonNull IOFunction<Path, FileStatusExt> statusGetter) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (statusGetter == null) {
            throw new NullPointerException("statusGetter is marked non-null but is null");
        }
        this.template = template;
        this.statusGetter = statusGetter;
    }
}

