/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AbortMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.CompleteMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagedFileHandle;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.UploadMetadata;
import java.io.IOException;
import lombok.NonNull;

public final class StagingMultipartUploadDispatcher
implements MultipartUploadDispatcher {
    @NonNull
    private final StagedFileHandle stagedFileHandle;
    @NonNull
    private final MultipartUploadDispatcher fallbackDispatcher;

    @Override
    public void complete(CompleteMultipartUploadEvent event) throws IOException {
        this.validateNoConcurrencyToken(event);
        this.stagedFileHandle.complete(UploadMetadata.of(event.getUploadId(), event.getPartETags(), event.getTotalLength()));
    }

    @Override
    public void abort(AbortMultipartUploadEvent event) throws IOException {
        this.fallbackDispatcher.abort(event);
    }

    private void validateNoConcurrencyToken(CompleteMultipartUploadEvent event) {
        ExtraUploadMetadata extraUploadMetadata = event.getExtraUploadMetadata();
        Preconditions.checkArgument(extraUploadMetadata.getConcurrencyToken() == null, "Expected event not to contain a ConcurrencyToken");
    }

    public StagingMultipartUploadDispatcher(@NonNull StagedFileHandle stagedFileHandle, @NonNull MultipartUploadDispatcher fallbackDispatcher) {
        if (stagedFileHandle == null) {
            throw new NullPointerException("stagedFileHandle is marked non-null but is null");
        }
        if (fallbackDispatcher == null) {
            throw new NullPointerException("fallbackDispatcher is marked non-null but is null");
        }
        this.stagedFileHandle = stagedFileHandle;
        this.fallbackDispatcher = fallbackDispatcher;
    }
}

