/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.event.ProgressListener;
import java.io.InputStream;
import lombok.NonNull;

public final class ObjectCreationEvent {
    @NonNull
    private final String bucket;
    @NonNull
    private final String key;
    @NonNull
    private final InputStream contentStream;
    private final long contentLength;
    private final String contentMD5;
    private final String serverSideEncryptionAlgorithm;
    private final ProgressListener progressListener;
    @NonNull
    private final ExtraUploadMetadata extraUploadMetadata;

    ObjectCreationEvent(@NonNull String bucket, @NonNull String key, @NonNull InputStream contentStream, long contentLength, String contentMD5, String serverSideEncryptionAlgorithm, ProgressListener progressListener, @NonNull ExtraUploadMetadata extraUploadMetadata) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (extraUploadMetadata == null) {
            throw new NullPointerException("extraUploadMetadata is marked non-null but is null");
        }
        this.bucket = bucket;
        this.key = key;
        this.contentStream = contentStream;
        this.contentLength = contentLength;
        this.contentMD5 = contentMD5;
        this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
        this.progressListener = progressListener;
        this.extraUploadMetadata = extraUploadMetadata;
    }

    public static ObjectCreationEventBuilder builder() {
        return new ObjectCreationEventBuilder();
    }

    @NonNull
    public String getBucket() {
        return this.bucket;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public InputStream getContentStream() {
        return this.contentStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public String getServerSideEncryptionAlgorithm() {
        return this.serverSideEncryptionAlgorithm;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @NonNull
    public ExtraUploadMetadata getExtraUploadMetadata() {
        return this.extraUploadMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectCreationEvent)) {
            return false;
        }
        ObjectCreationEvent other = (ObjectCreationEvent)o;
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        InputStream this$contentStream = this.getContentStream();
        InputStream other$contentStream = other.getContentStream();
        if (this$contentStream == null ? other$contentStream != null : !this$contentStream.equals(other$contentStream)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        String this$contentMD5 = this.getContentMD5();
        String other$contentMD5 = other.getContentMD5();
        if (this$contentMD5 == null ? other$contentMD5 != null : !this$contentMD5.equals(other$contentMD5)) {
            return false;
        }
        String this$serverSideEncryptionAlgorithm = this.getServerSideEncryptionAlgorithm();
        String other$serverSideEncryptionAlgorithm = other.getServerSideEncryptionAlgorithm();
        if (this$serverSideEncryptionAlgorithm == null ? other$serverSideEncryptionAlgorithm != null : !this$serverSideEncryptionAlgorithm.equals(other$serverSideEncryptionAlgorithm)) {
            return false;
        }
        ProgressListener this$progressListener = this.getProgressListener();
        ProgressListener other$progressListener = other.getProgressListener();
        if (this$progressListener == null ? other$progressListener != null : !this$progressListener.equals(other$progressListener)) {
            return false;
        }
        ExtraUploadMetadata this$extraUploadMetadata = this.getExtraUploadMetadata();
        ExtraUploadMetadata other$extraUploadMetadata = other.getExtraUploadMetadata();
        return !(this$extraUploadMetadata == null ? other$extraUploadMetadata != null : !((Object)this$extraUploadMetadata).equals(other$extraUploadMetadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        InputStream $contentStream = this.getContentStream();
        result = result * 59 + ($contentStream == null ? 43 : $contentStream.hashCode());
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        String $contentMD5 = this.getContentMD5();
        result = result * 59 + ($contentMD5 == null ? 43 : $contentMD5.hashCode());
        String $serverSideEncryptionAlgorithm = this.getServerSideEncryptionAlgorithm();
        result = result * 59 + ($serverSideEncryptionAlgorithm == null ? 43 : $serverSideEncryptionAlgorithm.hashCode());
        ProgressListener $progressListener = this.getProgressListener();
        result = result * 59 + ($progressListener == null ? 43 : $progressListener.hashCode());
        ExtraUploadMetadata $extraUploadMetadata = this.getExtraUploadMetadata();
        result = result * 59 + ($extraUploadMetadata == null ? 43 : ((Object)$extraUploadMetadata).hashCode());
        return result;
    }

    public String toString() {
        return "ObjectCreationEvent(bucket=" + this.getBucket() + ", key=" + this.getKey() + ", contentStream=" + this.getContentStream() + ", contentLength=" + this.getContentLength() + ", contentMD5=" + this.getContentMD5() + ", serverSideEncryptionAlgorithm=" + this.getServerSideEncryptionAlgorithm() + ", progressListener=" + this.getProgressListener() + ", extraUploadMetadata=" + this.getExtraUploadMetadata() + ")";
    }

    public static class ObjectCreationEventBuilder {
        private String bucket;
        private String key;
        private InputStream contentStream;
        private long contentLength;
        private String contentMD5;
        private String serverSideEncryptionAlgorithm;
        private ProgressListener progressListener;
        private ExtraUploadMetadata extraUploadMetadata;

        ObjectCreationEventBuilder() {
        }

        public ObjectCreationEventBuilder bucket(@NonNull String bucket) {
            if (bucket == null) {
                throw new NullPointerException("bucket is marked non-null but is null");
            }
            this.bucket = bucket;
            return this;
        }

        public ObjectCreationEventBuilder key(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public ObjectCreationEventBuilder contentStream(@NonNull InputStream contentStream) {
            if (contentStream == null) {
                throw new NullPointerException("contentStream is marked non-null but is null");
            }
            this.contentStream = contentStream;
            return this;
        }

        public ObjectCreationEventBuilder contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public ObjectCreationEventBuilder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public ObjectCreationEventBuilder serverSideEncryptionAlgorithm(String serverSideEncryptionAlgorithm) {
            this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
            return this;
        }

        public ObjectCreationEventBuilder progressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        public ObjectCreationEventBuilder extraUploadMetadata(@NonNull ExtraUploadMetadata extraUploadMetadata) {
            if (extraUploadMetadata == null) {
                throw new NullPointerException("extraUploadMetadata is marked non-null but is null");
            }
            this.extraUploadMetadata = extraUploadMetadata;
            return this;
        }

        public ObjectCreationEvent build() {
            return new ObjectCreationEvent(this.bucket, this.key, this.contentStream, this.contentLength, this.contentMD5, this.serverSideEncryptionAlgorithm, this.progressListener, this.extraUploadMetadata);
        }

        public String toString() {
            return "ObjectCreationEvent.ObjectCreationEventBuilder(bucket=" + this.bucket + ", key=" + this.key + ", contentStream=" + this.contentStream + ", contentLength=" + this.contentLength + ", contentMD5=" + this.contentMD5 + ", serverSideEncryptionAlgorithm=" + this.serverSideEncryptionAlgorithm + ", progressListener=" + this.progressListener + ", extraUploadMetadata=" + this.extraUploadMetadata + ")";
        }
    }
}

