/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.consistency.MetadataFiles;
import com.amazon.ws.emr.hadoop.fs.consistency.concurrent.ConcurrencyToken;
import com.amazon.ws.emr.hadoop.fs.consistency.concurrent.ConcurrentWriteHandler;
import com.amazon.ws.emr.hadoop.fs.consistency.concurrent.ConcurrentWrites;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreException;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ConcurrencyTokenResolver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserverContext;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserverContexts;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.util.S3Keys;
import java.io.IOException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataAdder
implements UploadObserver {
    private static final Logger logger = LoggerFactory.getLogger(MetadataAdder.class);
    static final UploadObserverContext.Store.Key<ConcurrencyToken> CONCURRENCY_TOKEN_KEY = UploadObserverContext.Store.Key.named(MetadataAdder.class, "ConcurrencyToken");
    @NonNull
    private final EntityStore<Entity> entityStore;
    @NonNull
    private final ConcurrencyTokenResolver tokenResolver;
    @NonNull
    private final MkdirsMetadataOperation mkdirsOperation;
    @NonNull
    private final ConcurrentWriteHandler concurrentWriteHandler;

    @Override
    public void beforeUploadCompletion(UploadObserverContext context) throws IOException {
        ConcurrencyToken token = this.tokenResolver.resolve(context);
        context.getStore().put(CONCURRENCY_TOKEN_KEY, token);
    }

    @Override
    public void afterUploadCompletion(UploadObserverContext context) throws IOException {
        ConcurrencyToken token = this.getConcurrencyTokenFromStoreOrFail(context);
        this.addParentDirectoriesMetadata(context);
        this.addFileMetadata(context, token);
    }

    private ConcurrencyToken getConcurrencyTokenFromStoreOrFail(UploadObserverContext context) {
        ConcurrencyToken concurrencyToken = context.getStore().get(CONCURRENCY_TOKEN_KEY);
        Preconditions.checkState(concurrencyToken != null, "%s is missing from context (%s)", CONCURRENCY_TOKEN_KEY.getName(), context);
        return concurrencyToken;
    }

    private void addParentDirectoriesMetadata(UploadObserverContext context) throws IOException {
        this.mkdirsOperation.run(context.getBucket(), this.getParentKey(context));
    }

    private String getParentKey(UploadObserverContext context) {
        return S3Keys.getParent(context.getKey()).orElseThrow(() -> new IllegalArgumentException("Cannot create file at root of bucket: " + context.getBucket()));
    }

    private void addFileMetadata(UploadObserverContext context, ConcurrencyToken concurrencyToken) throws IOException {
        ItemKey itemKey = UploadObserverContexts.getItemKey(context);
        Entity entityToAdd = this.newFileEntity(itemKey, concurrencyToken, context);
        this.addEntity(entityToAdd, concurrencyToken);
    }

    private Entity newFileEntity(ItemKey itemKey, ConcurrencyToken concurrencyToken, UploadObserverContext context) {
        return new Entity(itemKey, MetadataFiles.PLACED_FILE.toByteArray()).withCounter(concurrencyToken.getCounter()).withEtag(context.getStore().get(UploadObserverContext.ETAG_VERIFICATION_KEY));
    }

    private void addEntity(Entity entityToAdd, ConcurrencyToken concurrencyToken) throws IOException {
        try {
            if (concurrencyToken.isEntityExistent()) {
                this.entityStore.update(entityToAdd);
            } else {
                this.entityStore.create(entityToAdd);
            }
        }
        catch (EntityStoreException e) {
            if (ConcurrentWrites.isCausedByConcurrentWrite(e)) {
                this.concurrentWriteHandler.handle(entityToAdd, e);
            }
            throw e;
        }
    }

    public MetadataAdder(@NonNull EntityStore<Entity> entityStore, @NonNull ConcurrencyTokenResolver tokenResolver, @NonNull MkdirsMetadataOperation mkdirsOperation, @NonNull ConcurrentWriteHandler concurrentWriteHandler) {
        if (entityStore == null) {
            throw new NullPointerException("entityStore is marked non-null but is null");
        }
        if (tokenResolver == null) {
            throw new NullPointerException("tokenResolver is marked non-null but is null");
        }
        if (mkdirsOperation == null) {
            throw new NullPointerException("mkdirsOperation is marked non-null but is null");
        }
        if (concurrentWriteHandler == null) {
            throw new NullPointerException("concurrentWriteHandler is marked non-null but is null");
        }
        this.entityStore = entityStore;
        this.tokenResolver = tokenResolver;
        this.mkdirsOperation = mkdirsOperation;
        this.concurrentWriteHandler = concurrentWriteHandler;
    }

    public static interface MkdirsMetadataOperation {
        public void run(String var1, String var2) throws IOException;
    }
}

