/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserverContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

final class ChainedUploadObserver
implements UploadObserver {
    private final List<UploadObserver> observers;

    ChainedUploadObserver(List<UploadObserver> observers) {
        this.observers = ImmutableList.copyOf(observers);
    }

    @Override
    public void beforeUploadCompletion(UploadObserverContext context) throws IOException {
        for (UploadObserver observer : this.observers) {
            observer.beforeUploadCompletion(context);
        }
    }

    @Override
    public void afterUploadCompletion(UploadObserverContext context) throws IOException {
        for (UploadObserver observer : this.observers) {
            observer.afterUploadCompletion(context);
        }
    }
}

