/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.factory;

import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3EncryptionConfigurationV2;
import com.amazon.ws.emr.hadoop.fs.s3.lite.factory.S3EncryptionClientV2Factory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.metrics.RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClientV2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClientV2Builder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@ThreadSafe
public class DefaultS3EncryptionClientV2Factory
implements S3EncryptionClientV2Factory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultS3EncryptionClientV2Factory.class);

    @Override
    public AmazonS3EncryptionClientV2 newS3(@NotNull S3EncryptionConfigurationV2 s3Configuration, List<? extends RequestHandler2> requestHandlers, String region, RequestMetricCollector requestMetricCollector) {
        logger.debug("AmazonS3EncryptionClientV2Builder is creating s3 encryption client V2");
        AmazonS3EncryptionClientV2Builder builder = (AmazonS3EncryptionClientV2Builder)((AmazonS3EncryptionClientV2Builder)AmazonS3EncryptionClientV2Builder.standard().withCredentials(s3Configuration.getAwsCredentialsProvider())).withCryptoConfiguration((CryptoConfigurationV2)s3Configuration.getCryptoConfiguration()).withEncryptionMaterialsProvider(s3Configuration.getEncryptionMaterialsProvider()).withForceGlobalBucketAccessEnabled(true);
        if (!StringUtils.isNullOrEmpty(region)) {
            builder.withRegion(region);
        }
        if (s3Configuration.hasClientConfiguration()) {
            builder.withClientConfiguration(s3Configuration.getClientConfiguration());
        }
        if (requestHandlers != null) {
            builder.withRequestHandlers(requestHandlers.toArray(new RequestHandler2[0]));
        }
        if (s3Configuration.isMetricsEnabled()) {
            Preconditions.checkNotNull(requestMetricCollector, "RequestMetricCollector is required when isMetricsEnabled flag is set");
            builder.withMetricsCollector(requestMetricCollector);
        }
        return (AmazonS3EncryptionClientV2)builder.build();
    }
}

