/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.factory;

import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3EncryptionConfiguration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.factory.S3EncryptionClientFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.metrics.RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@ThreadSafe
final class DefaultS3EncryptionClientFactory
implements S3EncryptionClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultS3EncryptionClientFactory.class);

    DefaultS3EncryptionClientFactory() {
    }

    @Override
    public AmazonS3EncryptionClient newS3(@NotNull S3EncryptionConfiguration s3Configuration, List<? extends RequestHandler2> requestHandlers, String region, RequestMetricCollector requestMetricCollector) {
        logger.debug("AmazonS3EncryptionClientBuilder is creating s3 client");
        AmazonS3EncryptionClientBuilder builder = (AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withCredentials(s3Configuration.getAwsCredentialsProvider())).withCryptoConfiguration((CryptoConfiguration)s3Configuration.getCryptoConfiguration()).withEncryptionMaterials(s3Configuration.getEncryptionMaterialsProvider()).withForceGlobalBucketAccessEnabled(true);
        if (!StringUtils.isNullOrEmpty(region)) {
            builder.withRegion(region);
        }
        if (s3Configuration.hasClientConfiguration()) {
            builder.withClientConfiguration(s3Configuration.getClientConfiguration());
        }
        if (requestHandlers != null) {
            builder.withRequestHandlers(requestHandlers.toArray(new RequestHandler2[0]));
        }
        if (s3Configuration.isMetricsEnabled()) {
            Preconditions.checkNotNull(requestMetricCollector, "RequestMetricCollector is required when isMetricsEnabled flag is set");
            builder.withMetricsCollector(requestMetricCollector);
        }
        return (AmazonS3EncryptionClient)builder.build();
    }
}

