/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.factory;

import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3Configuration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.factory.S3ClientFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.metrics.RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3Client;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@ThreadSafe
final class DefaultS3ClientFactory
implements S3ClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultS3ClientFactory.class);

    DefaultS3ClientFactory() {
    }

    @Override
    public AmazonS3Client newS3(@NotNull S3Configuration s3Configuration, List<? extends RequestHandler2> requestHandlers, String region, RequestMetricCollector requestMetricCollector) {
        logger.debug("AmazonS3ClientBuilder is creating s3 client");
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(s3Configuration.getAwsCredentialsProvider())).withForceGlobalBucketAccessEnabled(true);
        if (!StringUtils.isNullOrEmpty(region)) {
            builder.withRegion(region);
        }
        if (s3Configuration.hasClientConfiguration()) {
            builder.withClientConfiguration(s3Configuration.getClientConfiguration());
        }
        if (requestHandlers != null) {
            builder.withRequestHandlers(requestHandlers.toArray(new RequestHandler2[0]));
        }
        if (s3Configuration.isMetricsEnabled()) {
            Preconditions.checkNotNull(requestMetricCollector, "RequestMetricCollector is required when isMetricsEnabled flag is set");
            builder.withMetricsCollector(requestMetricCollector);
        }
        return (AmazonS3Client)builder.build();
    }
}

