/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.configuration;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.ClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.NoSuchElementException;

public abstract class AbstractS3Configuration {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final ClientConfiguration clientConfiguration;
    private final boolean metricsEnabled;

    AbstractS3Configuration(Builder builder) {
        this.awsCredentialsProvider = builder.awsCredentialsProvider;
        this.clientConfiguration = builder.clientConfiguration;
        this.metricsEnabled = builder.metricsEnabled;
    }

    public final AWSCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public final boolean hasClientConfiguration() {
        return this.clientConfiguration != null;
    }

    public final ClientConfiguration getClientConfiguration() {
        if (!this.hasClientConfiguration()) {
            throw new NoSuchElementException("ClientConfiguration is absent");
        }
        return this.clientConfiguration;
    }

    public final boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    static abstract class Builder<T extends AbstractS3Configuration, B extends Builder<T, B>> {
        private AWSCredentialsProvider awsCredentialsProvider;
        private ClientConfiguration clientConfiguration;
        private boolean metricsEnabled;

        Builder() {
        }

        public final B awsCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
            this.awsCredentialsProvider = awsCredentialsProvider;
            return this.getThisAsChildType();
        }

        public final B clientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this.getThisAsChildType();
        }

        public final B metricsEnabled(boolean metricEnabled) {
            this.metricsEnabled = metricEnabled;
            return this.getThisAsChildType();
        }

        public final T build() {
            Preconditions.checkNotNull(this.awsCredentialsProvider, "AwsCredentialsProvider is required");
            return this.newInstance();
        }

        abstract T newInstance();

        private B getThisAsChildType() {
            return (B)this;
        }
    }
}

