/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.collector;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.Response;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.metrics.RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.AWSRequestMetrics;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.TimingInfo;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;

public class S3RequestMetricCollector
extends RequestMetricCollector {
    private final FileSystem.Statistics statistics;

    public S3RequestMetricCollector(FileSystem.Statistics statistics) {
        this.statistics = Objects.requireNonNull(statistics, "Statistics is required for collector");
    }

    @Override
    public void collectMetrics(Request<?> request, Response<?> response) {
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        TimingInfo timingInfo = metrics.getTimingInfo();
        Number throttleExceptions = timingInfo.getCounter(AWSRequestMetrics.Field.ThrottleException.name());
        if (throttleExceptions != null) {
            this.statistics.incrementThrottledRequestCount(throttleExceptions.longValue());
        }
    }
}

