/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.exception.RuntimeExecutionException;
import com.amazon.ws.emr.hadoop.fs.exception.RuntimeIOException;
import com.amazon.ws.emr.hadoop.fs.exception.RuntimeInterruptedException;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.AbstractUploadObjectCall;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadObjectRequest;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public final class UploadObjectCall
extends AbstractUploadObjectCall<AmazonS3EncryptionClient> {
    public UploadObjectCall(UploadObjectRequest request) {
        super(request);
    }

    @Override
    protected CompleteMultipartUploadResult performCall(AmazonS3EncryptionClient client, UploadObjectRequest request) {
        try {
            return client.uploadObject(request);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeExecutionException(e);
        }
    }
}

