/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import java.util.Collection;

final class S3Resources {
    private S3Resources() {
    }

    static Collection<S3Resource> fromBucket(String bucketName) {
        return ImmutableList.of(S3Resources.newS3Bucket(bucketName));
    }

    static Collection<S3Resource> fromBucketAndKey(String bucketName, String key) {
        return ImmutableList.of(S3Resources.newS3Object(bucketName, key));
    }

    static Collection<S3Resource> fromBucketAndPrefix(String bucketName, String prefix) {
        return ImmutableList.of(S3Resources.newS3Prefix(bucketName, prefix));
    }

    static Collection<S3Resource> fromSourceAndDestination(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        return ImmutableList.of(S3Resources.newS3Object(sourceBucketName, sourceKey), S3Resources.newS3Object(destinationBucketName, destinationKey));
    }

    static Collection<S3Resource> fromBucketAndKeys(String bucketName, Collection<String> keys) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : keys) {
            builder.add(S3Resources.newS3Object(bucketName, key));
        }
        return builder.build();
    }

    private static S3Resource newS3Bucket(String bucketName) {
        return new GenericS3Resource(S3Resource.Type.BUCKET, bucketName, null);
    }

    private static S3Resource newS3Object(String bucketName, String key) {
        return new GenericS3Resource(S3Resource.Type.OBJECT, bucketName, key);
    }

    private static S3Resource newS3Prefix(String bucketName, String prefix) {
        return new GenericS3Resource(S3Resource.Type.PREFIX, bucketName, prefix);
    }

    private static final class GenericS3Resource
    implements S3Resource {
        private final S3Resource.Type type;
        private final String bucketName;
        private final String path;

        private GenericS3Resource(S3Resource.Type type, String bucketName, String path) {
            this.type = type;
            this.bucketName = bucketName;
            this.path = path;
        }

        @Override
        public S3Resource.Type getType() {
            return this.type;
        }

        @Override
        public String getBucketName() {
            return this.bucketName;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String toString() {
            if (!Strings.isNullOrEmpty(this.path)) {
                return (Object)((Object)this.type) + " : " + this.bucketName + "/" + this.path;
            }
            return (Object)((Object)this.type) + " : " + this.bucketName;
        }
    }
}

