/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Call;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resources;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.policy.actions.S3Actions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.Collection;
import java.util.List;

public final class DoesBucketExistCall
implements S3Call<Boolean, AmazonS3> {
    private final String bucketName;

    public DoesBucketExistCall(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public Boolean perform(AmazonS3 amazonS3) {
        return amazonS3.doesBucketExist(this.bucketName);
    }

    @Override
    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
    }

    @Override
    public void enableRequesterPays() {
    }

    @Override
    public Collection<S3Resource> getS3Resources() {
        return S3Resources.fromBucket(this.bucketName);
    }

    @Override
    public List<S3Actions> getS3Actions() {
        return ImmutableList.of(S3Actions.ListBuckets);
    }
}

