/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.s3.lite.call.AbstractS3GenericCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resources;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.policy.actions.S3Actions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class DeleteObjectCall
extends AbstractS3GenericCall<Void, DeleteObjectRequest> {
    public DeleteObjectCall(String bucketName, String key) {
        super(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public String getBucketName() {
        return ((DeleteObjectRequest)this.request).getBucketName();
    }

    @Override
    public Void perform(AmazonS3 amazonS3) {
        amazonS3.deleteObject((DeleteObjectRequest)this.request);
        return null;
    }

    @Override
    public Collection<S3Resource> getS3Resources() {
        return S3Resources.fromBucketAndKey(((DeleteObjectRequest)this.request).getBucketName(), ((DeleteObjectRequest)this.request).getKey());
    }

    @Override
    public List<S3Actions> getS3Actions() {
        return ImmutableList.of(S3Actions.DeleteObject);
    }
}

