/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.s3.lite.call.AbstractS3GenericCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resources;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.policy.actions.S3Actions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyPartResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class CopyPartCall
extends AbstractS3GenericCall<CopyPartResult, CopyPartRequest> {
    public CopyPartCall(CopyPartRequest request) {
        super(request);
    }

    @Override
    public String getBucketName() {
        return ((CopyPartRequest)this.request).getDestinationBucketName();
    }

    @Override
    public CopyPartResult perform(AmazonS3 amazonS3) {
        return amazonS3.copyPart((CopyPartRequest)this.request);
    }

    @Override
    public Collection<S3Resource> getS3Resources() {
        return S3Resources.fromSourceAndDestination(((CopyPartRequest)this.request).getSourceBucketName(), ((CopyPartRequest)this.request).getSourceKey(), ((CopyPartRequest)this.request).getDestinationBucketName(), ((CopyPartRequest)this.request).getDestinationKey());
    }

    @Override
    public List<S3Actions> getS3Actions() {
        return ImmutableList.of(S3Actions.GetObject, S3Actions.PutObject);
    }
}

