/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite.call;

import com.amazon.ws.emr.hadoop.fs.s3.lite.call.AbstractS3GenericCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resources;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.policy.actions.S3Actions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class CopyObjectCall
extends AbstractS3GenericCall<CopyObjectResult, CopyObjectRequest> {
    public CopyObjectCall(CopyObjectRequest request) {
        super(request);
    }

    @Override
    public String getBucketName() {
        return ((CopyObjectRequest)this.request).getDestinationBucketName();
    }

    @Override
    public CopyObjectResult perform(AmazonS3 amazonS3) {
        return amazonS3.copyObject((CopyObjectRequest)this.request);
    }

    @Override
    public Collection<S3Resource> getS3Resources() {
        return S3Resources.fromSourceAndDestination(((CopyObjectRequest)this.request).getSourceBucketName(), ((CopyObjectRequest)this.request).getSourceKey(), ((CopyObjectRequest)this.request).getDestinationBucketName(), ((CopyObjectRequest)this.request).getDestinationKey());
    }

    @Override
    public List<S3Actions> getS3Actions() {
        return ImmutableList.of(S3Actions.GetObject, S3Actions.PutObject);
    }
}

