/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite;

import com.amazon.ws.emr.hadoop.fs.retry.BackoffStrategies;
import com.amazon.ws.emr.hadoop.fs.retry.BackoffStrategy;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLiteClient;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLiteClientV2;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3LiteClient;
import com.amazon.ws.emr.hadoop.fs.s3.lite.bucket.BucketRegionStore;
import com.amazon.ws.emr.hadoop.fs.s3.lite.collector.S3RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.AbstractS3EncryptionConfiguration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3Configuration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3EncryptionConfiguration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3EncryptionConfigurationV2;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.GlobalS3Executor;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.S3CallOverrider;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.S3Executor;
import com.amazon.ws.emr.hadoop.fs.s3.lite.factory.S3Factories;
import com.amazon.ws.emr.hadoop.fs.s3.lite.factory.S3Factory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.provider.DefaultS3Provider;
import com.amazon.ws.emr.hadoop.fs.s3.lite.provider.S3Provider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.RequestHandler2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.metrics.RequestMetricCollector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3Client;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClientV2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.MoreObjects;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.jetbrains.annotations.NotNull;

public final class AmazonS3LiteClientFactory {
    private static final long RETRY_INTERVAL_MS = 1000L;
    private final S3Factory<AmazonS3Client, S3Configuration> s3Factory;
    private final S3Factory<AmazonS3EncryptionClient, S3EncryptionConfiguration> s3EncryptionFactory;
    private final S3Factory<AmazonS3EncryptionClientV2, S3EncryptionConfigurationV2> s3EncryptionV2Factory;
    private final BucketRegionStore bucketRegionStore;
    private final List<? extends RequestHandler2> defaultRequestHandlers;

    AmazonS3LiteClientFactory(BucketRegionStore bucketRegionStore) {
        this(S3Factories.clientFactory(), S3Factories.encryptionClientFactory(), S3Factories.encryptionClientV2Factory(), bucketRegionStore);
    }

    @VisibleForTesting
    AmazonS3LiteClientFactory(S3Factory<AmazonS3Client, S3Configuration> s3Factory, S3Factory<AmazonS3EncryptionClient, S3EncryptionConfiguration> s3EncryptionFactory, S3Factory<AmazonS3EncryptionClientV2, S3EncryptionConfigurationV2> s3EncryptionV2Factory, BucketRegionStore bucketRegionStore) {
        this.s3Factory = s3Factory;
        this.s3EncryptionFactory = s3EncryptionFactory;
        this.s3EncryptionV2Factory = s3EncryptionV2Factory;
        this.bucketRegionStore = bucketRegionStore;
        this.defaultRequestHandlers = EmrFsUtils.getDefaultRequestHandlers();
    }

    public AmazonS3Lite newClient(S3Configuration s3Configuration, @Nullable S3Configuration initialTimeoutS3Configuration, String defaultRegion, @Nullable List<S3CallOverrider> overriders, @Nullable FileSystem.Statistics statistics, @Nullable List<? extends RequestHandler2> customRequestHandlers) {
        Preconditions.checkNotNull(s3Configuration, "S3Configuration is required");
        Preconditions.checkNotNull(defaultRegion, "DefaultRegion is required");
        if (s3Configuration.isMetricsEnabled()) {
            Preconditions.checkNotNull(statistics, "Statistics is required when metrics is enabled in s3 configuration");
        }
        return new AmazonS3LiteClient<AmazonS3Client>(this.newExecutor(this.newProvider(this.s3Factory, s3Configuration, initialTimeoutS3Configuration, statistics, this.getAllRequestHandlers(customRequestHandlers)), defaultRegion, MoreObjects.firstNonNull(overriders, ImmutableList.of())));
    }

    public AmazonS3EncryptionLiteClient newEncryptionClient(S3EncryptionConfiguration s3EncryptionConfiguration, @Nullable S3EncryptionConfiguration s3EncryptionInitialTimeoutConfiguration, String defaultRegion, @Nullable List<S3CallOverrider> overriders, @Nullable FileSystem.Statistics statistics, @Nullable List<? extends RequestHandler2> customRequestHandlers) {
        return new AmazonS3EncryptionLiteClient(this.newEncryptionExecutor(this.s3EncryptionFactory, s3EncryptionConfiguration, s3EncryptionInitialTimeoutConfiguration, defaultRegion, overriders, statistics, customRequestHandlers));
    }

    public AmazonS3EncryptionLiteClientV2 newEncryptionClientV2(S3EncryptionConfigurationV2 s3EncryptionConfiguration, @Nullable S3EncryptionConfigurationV2 s3EncryptionInitialTimeoutConfiguration, String defaultRegion, @Nullable List<S3CallOverrider> overriders, @Nullable FileSystem.Statistics statistics, @Nullable List<? extends RequestHandler2> customRequestHandlers) {
        return new AmazonS3EncryptionLiteClientV2(this.newEncryptionExecutor(this.s3EncryptionV2Factory, s3EncryptionConfiguration, s3EncryptionInitialTimeoutConfiguration, defaultRegion, overriders, statistics, customRequestHandlers));
    }

    private <S extends AmazonS3Client, C extends AbstractS3EncryptionConfiguration, F extends S3Factory<S, C>> S3Executor<S> newEncryptionExecutor(@NotNull F s3encryptionFactory, C s3EncryptionConfiguration, @Nullable C s3EncryptionInitialTimeoutConfiguration, String defaultRegion, @Nullable List<S3CallOverrider> overriders, @Nullable FileSystem.Statistics statistics, @Nullable List<? extends RequestHandler2> customRequestHandlers) {
        Preconditions.checkNotNull(s3EncryptionConfiguration, "S3EncryptionConfigurationV2 is required");
        Preconditions.checkNotNull(defaultRegion, "DefaultRegion is required");
        return this.newExecutor(this.newProvider(s3encryptionFactory, s3EncryptionConfiguration, s3EncryptionInitialTimeoutConfiguration, statistics, this.getAllRequestHandlers(customRequestHandlers)), defaultRegion, MoreObjects.firstNonNull(overriders, ImmutableList.of()));
    }

    private <C extends AmazonS3Client, S> S3Provider<C> newProvider(S3Factory<C, S> s3Factory, S s3Configuration, @Nullable S initialRetryS3Configuration, @Nullable FileSystem.Statistics statistics, List<? extends RequestHandler2> allRequestHandlers) {
        return new DefaultS3Provider<C, S>(s3Factory, s3Configuration, initialRetryS3Configuration, allRequestHandlers, this.getRequestMetricCollector(statistics));
    }

    private <C extends AmazonS3Client> S3Executor<C> newExecutor(S3Provider<C> s3Provider, String defaultRegion, List<S3CallOverrider> overriders) {
        BackoffStrategy backoffStrategy = BackoffStrategies.exponential(1000L);
        return new GlobalS3Executor<C>(s3Provider, defaultRegion, this.bucketRegionStore, overriders, backoffStrategy);
    }

    private RequestMetricCollector getRequestMetricCollector(FileSystem.Statistics statistics) {
        return statistics != null ? new S3RequestMetricCollector(statistics) : null;
    }

    private List<? extends RequestHandler2> getAllRequestHandlers(List<? extends RequestHandler2> customRequestHandlers) {
        if (customRequestHandlers == null) {
            return this.defaultRequestHandlers;
        }
        ImmutableList.Builder requestHandlerBuilder = ImmutableList.builder();
        requestHandlerBuilder.addAll(this.defaultRequestHandlers);
        requestHandlerBuilder.addAll(customRequestHandlers);
        return requestHandlerBuilder.build();
    }

    public AmazonS3LiteBuilder clientBuilder() {
        return new AmazonS3LiteBuilder();
    }

    public AmazonS3EncryptionLiteClientBuilder encryptionClientBuilder() {
        return new AmazonS3EncryptionLiteClientBuilder();
    }

    public AmazonS3EncryptionLiteClientV2Builder encryptionClientV2Builder() {
        return new AmazonS3EncryptionLiteClientV2Builder();
    }

    public class AmazonS3EncryptionLiteClientV2Builder {
        private S3EncryptionConfigurationV2 s3EncryptionConfiguration;
        private S3EncryptionConfigurationV2 s3EncryptionInitialTimeoutConfiguration;
        private String defaultRegion;
        private List<S3CallOverrider> overriders;
        private FileSystem.Statistics statistics;
        private List<? extends RequestHandler2> customRequestHandlers;

        AmazonS3EncryptionLiteClientV2Builder() {
        }

        public AmazonS3EncryptionLiteClientV2Builder s3EncryptionConfiguration(S3EncryptionConfigurationV2 s3EncryptionConfiguration) {
            this.s3EncryptionConfiguration = s3EncryptionConfiguration;
            return this;
        }

        public AmazonS3EncryptionLiteClientV2Builder s3EncryptionInitialTimeoutConfiguration(@Nullable S3EncryptionConfigurationV2 s3EncryptionInitialTimeoutConfiguration) {
            this.s3EncryptionInitialTimeoutConfiguration = s3EncryptionInitialTimeoutConfiguration;
            return this;
        }

        public AmazonS3EncryptionLiteClientV2Builder defaultRegion(String defaultRegion) {
            this.defaultRegion = defaultRegion;
            return this;
        }

        public AmazonS3EncryptionLiteClientV2Builder overriders(@Nullable List<S3CallOverrider> overriders) {
            this.overriders = overriders;
            return this;
        }

        public AmazonS3EncryptionLiteClientV2Builder statistics(@Nullable FileSystem.Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public AmazonS3EncryptionLiteClientV2Builder customRequestHandlers(@Nullable List<? extends RequestHandler2> customRequestHandlers) {
            this.customRequestHandlers = customRequestHandlers;
            return this;
        }

        public AmazonS3EncryptionLiteClientV2 build() {
            return AmazonS3LiteClientFactory.this.newEncryptionClientV2(this.s3EncryptionConfiguration, this.s3EncryptionInitialTimeoutConfiguration, this.defaultRegion, this.overriders, this.statistics, this.customRequestHandlers);
        }

        public String toString() {
            return "AmazonS3LiteClientFactory.AmazonS3EncryptionLiteClientV2Builder(s3EncryptionConfiguration=" + this.s3EncryptionConfiguration + ", s3EncryptionInitialTimeoutConfiguration=" + this.s3EncryptionInitialTimeoutConfiguration + ", defaultRegion=" + this.defaultRegion + ", overriders=" + this.overriders + ", statistics=" + this.statistics + ", customRequestHandlers=" + this.customRequestHandlers + ")";
        }
    }

    public class AmazonS3EncryptionLiteClientBuilder {
        private S3EncryptionConfiguration s3EncryptionConfiguration;
        private S3EncryptionConfiguration s3EncryptionInitialTimeoutConfiguration;
        private String defaultRegion;
        private List<S3CallOverrider> overriders;
        private FileSystem.Statistics statistics;
        private List<? extends RequestHandler2> customRequestHandlers;

        AmazonS3EncryptionLiteClientBuilder() {
        }

        public AmazonS3EncryptionLiteClientBuilder s3EncryptionConfiguration(S3EncryptionConfiguration s3EncryptionConfiguration) {
            this.s3EncryptionConfiguration = s3EncryptionConfiguration;
            return this;
        }

        public AmazonS3EncryptionLiteClientBuilder s3EncryptionInitialTimeoutConfiguration(@Nullable S3EncryptionConfiguration s3EncryptionInitialTimeoutConfiguration) {
            this.s3EncryptionInitialTimeoutConfiguration = s3EncryptionInitialTimeoutConfiguration;
            return this;
        }

        public AmazonS3EncryptionLiteClientBuilder defaultRegion(String defaultRegion) {
            this.defaultRegion = defaultRegion;
            return this;
        }

        public AmazonS3EncryptionLiteClientBuilder overriders(@Nullable List<S3CallOverrider> overriders) {
            this.overriders = overriders;
            return this;
        }

        public AmazonS3EncryptionLiteClientBuilder statistics(@Nullable FileSystem.Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public AmazonS3EncryptionLiteClientBuilder customRequestHandlers(@Nullable List<? extends RequestHandler2> customRequestHandlers) {
            this.customRequestHandlers = customRequestHandlers;
            return this;
        }

        public AmazonS3EncryptionLiteClient build() {
            return AmazonS3LiteClientFactory.this.newEncryptionClient(this.s3EncryptionConfiguration, this.s3EncryptionInitialTimeoutConfiguration, this.defaultRegion, this.overriders, this.statistics, this.customRequestHandlers);
        }

        public String toString() {
            return "AmazonS3LiteClientFactory.AmazonS3EncryptionLiteClientBuilder(s3EncryptionConfiguration=" + this.s3EncryptionConfiguration + ", s3EncryptionInitialTimeoutConfiguration=" + this.s3EncryptionInitialTimeoutConfiguration + ", defaultRegion=" + this.defaultRegion + ", overriders=" + this.overriders + ", statistics=" + this.statistics + ", customRequestHandlers=" + this.customRequestHandlers + ")";
        }
    }

    public class AmazonS3LiteBuilder {
        private S3Configuration s3Configuration;
        private S3Configuration initialTimeoutS3Configuration;
        private String defaultRegion;
        private List<S3CallOverrider> overriders;
        private FileSystem.Statistics statistics;
        private List<? extends RequestHandler2> customRequestHandlers;

        AmazonS3LiteBuilder() {
        }

        public AmazonS3LiteBuilder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public AmazonS3LiteBuilder initialTimeoutS3Configuration(@Nullable S3Configuration initialTimeoutS3Configuration) {
            this.initialTimeoutS3Configuration = initialTimeoutS3Configuration;
            return this;
        }

        public AmazonS3LiteBuilder defaultRegion(String defaultRegion) {
            this.defaultRegion = defaultRegion;
            return this;
        }

        public AmazonS3LiteBuilder overriders(@Nullable List<S3CallOverrider> overriders) {
            this.overriders = overriders;
            return this;
        }

        public AmazonS3LiteBuilder statistics(@Nullable FileSystem.Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public AmazonS3LiteBuilder customRequestHandlers(@Nullable List<? extends RequestHandler2> customRequestHandlers) {
            this.customRequestHandlers = customRequestHandlers;
            return this;
        }

        public AmazonS3Lite build() {
            return AmazonS3LiteClientFactory.this.newClient(this.s3Configuration, this.initialTimeoutS3Configuration, this.defaultRegion, this.overriders, this.statistics, this.customRequestHandlers);
        }

        public String toString() {
            return "AmazonS3LiteClientFactory.AmazonS3LiteBuilder(s3Configuration=" + this.s3Configuration + ", initialTimeoutS3Configuration=" + this.initialTimeoutS3Configuration + ", defaultRegion=" + this.defaultRegion + ", overriders=" + this.overriders + ", statistics=" + this.statistics + ", customRequestHandlers=" + this.customRequestHandlers + ")";
        }
    }
}

