/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3.lite;

import com.amazon.ws.emr.hadoop.fs.s3.lite.AbstractAmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.AbortMultipartUploadCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.CompleteMultipartUploadCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.CopyObjectCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.CopyPartCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.CreateBucketCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.DeleteObjectCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.DeleteObjectsCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.DoesBucketExistCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.GetBucketVersioningConfigurationCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.GetObjectCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.GetObjectMetadataCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.InitiateMultipartUploadCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.ListMultipartUploadsCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.ListObjectsV2Call;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.ListPartsCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.ListVersionsCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.PutObjectCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Call;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.SelectObjectContentCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.SetBucketVersioningConfigurationCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.UploadPartCall;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.S3Executor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.AmazonS3;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.Bucket;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyPartResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartListing;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PutObjectResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3Object;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.VersionListing;
import com.amazon.ws.emr.hadoop.fs.util.io.MoreCloseables;
import java.io.Closeable;
import java.io.IOException;

class AmazonS3LiteClient<C extends AmazonS3>
extends AbstractAmazonS3Lite {
    private final S3Executor<C> executor;

    AmazonS3LiteClient(S3Executor<C> executor) {
        this.executor = executor;
    }

    @Override
    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request request) throws AmazonClientException {
        return this.invoke(new ListObjectsV2Call(request));
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest request) throws AmazonClientException {
        return this.invoke(new ListVersionsCall(request));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest request) throws AmazonClientException {
        return this.invoke(new CreateBucketCall(request));
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws AmazonClientException {
        return this.invoke(new DoesBucketExistCall(bucketName));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest request) throws AmazonClientException {
        return this.invoke(new GetObjectMetadataCall(request));
    }

    @Override
    public S3Object getObject(GetObjectRequest request, boolean shouldTryInitialTimeout) throws AmazonClientException {
        return this.invoke(new GetObjectCall(request), shouldTryInitialTimeout);
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws AmazonClientException {
        return this.invoke(new PutObjectCall(request));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) throws AmazonClientException {
        return this.invoke(new CopyObjectCall(request));
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest request) throws AmazonClientException {
        return this.invoke(new CopyPartCall(request));
    }

    @Override
    public void deleteObject(String bucketName, String key) throws AmazonClientException {
        this.invoke(new DeleteObjectCall(bucketName, key));
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest request) throws AmazonClientException {
        return this.invoke(new DeleteObjectsCall(request));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucket) throws AmazonClientException {
        return this.invoke(new GetBucketVersioningConfigurationCall(bucket));
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest request) throws AmazonClientException {
        this.invoke(new SetBucketVersioningConfigurationCall(request));
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws AmazonClientException {
        return this.invoke(new InitiateMultipartUploadCall(request));
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws AmazonClientException {
        return this.invoke(new UploadPartCall(request));
    }

    @Override
    public PartListing listParts(ListPartsRequest request) throws AmazonClientException {
        return this.invoke(new ListPartsCall(request));
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest request) throws AmazonClientException {
        this.invoke(new AbortMultipartUploadCall(request));
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws AmazonClientException {
        return this.invoke(new CompleteMultipartUploadCall(request));
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest request) throws AmazonClientException {
        return this.invoke(new ListMultipartUploadsCall(request));
    }

    @Override
    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest request) throws AmazonClientException {
        return this.invoke(new SelectObjectContentCall(request));
    }

    protected <R> R invoke(S3Call<R, ? super C> call) {
        return this.invoke(call, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R invoke(S3Call<R, ? super C> call, boolean shouldTryInitialTimeout) {
        try (Closeable ignored = MoreCloseables.asCloseable(call);){
            R r = this.executor.execute(call, shouldTryInitialTimeout);
            return r;
        }
        catch (IOException e) {
            throw new AmazonClientException("Failed to close the S3Call", e);
        }
    }
}

