/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.StorageClass;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;

public class S3ObjectRequestFactory {
    private Configuration configuration;
    private String serverSideEncryptionKmsKeyId;
    private StorageClass storageClass;
    private CannedAccessControlList cannedAccessControlList;

    public S3ObjectRequestFactory(Configuration configuration, String serverSideEncryptionKmsKeyId) {
        Preconditions.checkNotNull(configuration, "Configuration cannot be null.");
        this.configuration = configuration;
        this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        this.storageClass = ConfigurationUtils.getStorageClass(configuration);
        this.cannedAccessControlList = ConfigurationUtils.getAcl(configuration);
    }

    public PutObjectRequest newPutObjectRequest(String bucketName, String key, InputStream inputStream, ObjectMetadata metadata) {
        PutObjectRequest request = ConfigurationUtils.isClientSideEncryptionEnabled(this.configuration) ? new EncryptedPutObjectRequest(bucketName, key, inputStream, metadata).withMaterialsDescription(CSEUtils.getMaterialsDescription(this.configuration, S3UriUtils.getPathForS3Object(bucketName, key))) : new PutObjectRequest(bucketName, key, inputStream, metadata);
        if (this.storageClass != null) {
            request.setStorageClass(this.storageClass);
        }
        if (this.isServerSideEncryptionWithKmsKeyId()) {
            request = request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.serverSideEncryptionKmsKeyId));
        }
        if (this.cannedAccessControlList != null) {
            request.withCannedAcl(this.cannedAccessControlList);
        }
        return request;
    }

    public CopyObjectRequest newCopyObjectRequest(String srcBucketName, String srcKey, String dstBucketName, String dstKey) {
        CopyObjectRequest request = new CopyObjectRequest(srcBucketName, srcKey, dstBucketName, dstKey);
        if (this.isServerSideEncryptionWithKmsKeyId()) {
            request = request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.serverSideEncryptionKmsKeyId));
        }
        if (this.storageClass != null) {
            request.setStorageClass(this.storageClass);
        }
        return request;
    }

    public InitiateMultipartUploadRequest newMultipartUploadRequest(String dstBucketName, String dstKey) {
        InitiateMultipartUploadRequest request = ConfigurationUtils.isClientSideEncryptionEnabled(this.configuration) ? new EncryptedInitiateMultipartUploadRequest(dstBucketName, dstKey).withCreateEncryptionMaterial(false) : new InitiateMultipartUploadRequest(dstBucketName, dstKey);
        if (this.isServerSideEncryptionWithKmsKeyId()) {
            request = request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.serverSideEncryptionKmsKeyId));
        }
        if (this.storageClass != null) {
            request.setStorageClass(this.storageClass);
        }
        if (this.cannedAccessControlList != null) {
            request.setCannedACL(this.cannedAccessControlList);
        }
        return request;
    }

    public GetObjectRequest newGetObjectRequest(String bucketName, String key, long start, long end) {
        return new GetObjectRequest(bucketName, key).withRange(start, end);
    }

    private boolean isServerSideEncryptionWithKmsKeyId() {
        return !Strings.isNullOrEmpty(this.serverSideEncryptionKmsKeyId);
    }
}

