/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Function;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.AbstractIterator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterators;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.tuple.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ObjectIterator
extends AbstractIterator<Pair<S3ObjectSummary, String>> {
    private static final Logger logger = LoggerFactory.getLogger(S3ObjectIterator.class);
    private final AmazonS3Lite s3;
    Function<Pair<S3ObjectSummary, String>, Pair<S3ObjectSummary, String>> s3ObjectSummaryTransformer;
    Function<Pair<S3ObjectSummary, String>, Pair<S3ObjectSummary, String>> commonPrefixTransformer;
    private ListObjectsV2Request request;
    private Iterator<Pair<S3ObjectSummary, String>> iterator = null;
    private String inclusiveEndKey;

    public S3ObjectIterator(AmazonS3Lite s3, ListObjectsV2Request listObjectsRequest, Function<Pair<S3ObjectSummary, String>, Pair<S3ObjectSummary, String>> s3ObjectSummaryTransformer, Function<Pair<S3ObjectSummary, String>, Pair<S3ObjectSummary, String>> commonPrefixTransformer, String inclusiveEndKey) {
        this.s3 = s3;
        this.request = (ListObjectsV2Request)listObjectsRequest.clone();
        this.s3ObjectSummaryTransformer = s3ObjectSummaryTransformer;
        this.commonPrefixTransformer = commonPrefixTransformer;
        this.inclusiveEndKey = inclusiveEndKey;
    }

    @Override
    protected Pair<S3ObjectSummary, String> computeNext() {
        while (true) {
            if (this.iterator != null && this.iterator.hasNext()) {
                Pair<S3ObjectSummary, String> ret = this.iterator.next();
                if (this.inclusiveEndKey != null) {
                    String key;
                    String string = key = ret.getLeft() != null ? ret.getLeft().getKey() : ret.getRight();
                    if (key.compareTo(this.inclusiveEndKey) > 0) {
                        return (Pair)this.endOfData();
                    }
                }
                return ret;
            }
            if (this.request == null) {
                return (Pair)this.endOfData();
            }
            ListObjectsV2Result result = this.s3.listObjectsV2(this.request);
            if (result.isTruncated()) {
                this.request.setContinuationToken(result.getNextContinuationToken());
            } else {
                this.request = null;
            }
            this.iterator = this.getIteratorForResult(result);
        }
    }

    private Iterator<Pair<S3ObjectSummary, String>> getIteratorForResult(ListObjectsV2Result result) {
        List<String> commonPrefixes;
        Iterator<Pair<S3ObjectSummary, String>> files;
        Comparator<Pair<S3ObjectSummary, String>> comparator = new Comparator<Pair<S3ObjectSummary, String>>(){

            @Override
            public int compare(Pair<S3ObjectSummary, String> o1, Pair<S3ObjectSummary, String> o2) {
                if (o1.getLeft() == null) {
                    if (o2.getLeft() == null) {
                        return o1.getRight().compareTo(o2.getRight());
                    }
                    return o1.getRight().compareTo(o2.getLeft().getKey());
                }
                if (o2.getLeft() == null) {
                    return o1.getLeft().getKey().compareTo(o2.getRight());
                }
                return o1.getKey().getKey().compareTo(o2.getLeft().getKey());
            }
        };
        ArrayList<Iterator<Pair<S3ObjectSummary, String>>> iterators = Lists.newArrayList();
        List<S3ObjectSummary> objectSummaries = result.getObjectSummaries();
        if (objectSummaries != null && !objectSummaries.isEmpty()) {
            files = Iterators.transform(objectSummaries.iterator(), new Function<S3ObjectSummary, Pair<S3ObjectSummary, String>>(){

                @Override
                public Pair<S3ObjectSummary, String> apply(S3ObjectSummary objectSummary) {
                    return Pair.of(objectSummary, null);
                }
            });
            if (this.s3ObjectSummaryTransformer != null) {
                files = Iterators.transform(files, this.s3ObjectSummaryTransformer);
                ArrayList<Pair<S3ObjectSummary, String>> list = Lists.newArrayList(files);
                Collections.sort(list, comparator);
                files = list.iterator();
            }
            iterators.add(files);
        }
        if ((commonPrefixes = result.getCommonPrefixes()) != null && !commonPrefixes.isEmpty()) {
            files = Iterators.transform(commonPrefixes.iterator(), new Function<String, Pair<S3ObjectSummary, String>>(){

                @Override
                public Pair<S3ObjectSummary, String> apply(String prefix) {
                    return Pair.of(null, prefix);
                }
            });
            if (this.commonPrefixTransformer != null) {
                files = Iterators.transform(files, this.commonPrefixTransformer);
                ArrayList<Pair<S3ObjectSummary, String>> list = Lists.newArrayList(files);
                Collections.sort(list, comparator);
                files = list.iterator();
            }
            iterators.add(files);
        }
        return Iterators.mergeSorted(iterators, comparator);
    }
}

