/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.s3.EmrFSDataInputStreamBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataInputStreamBuilder;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryCapable;
import org.apache.hadoop.fs.staging.UnsupportedStagingDirectoryOperationException;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3NativeCommonFileSystem
extends FileSystem
implements StagingDirectoryCapable {
    private static final Logger logger = LoggerFactory.getLogger(S3NativeCommonFileSystem.class);
    public static final String PATH_DELIMITER = "/";
    protected URI uri;
    protected Path workingDirectory;
    protected String serverSideEncryptionAlgorithm = null;
    @Inject
    private FileSystem.Statistics emrFileSystemStatistics;

    public void initialize(URI uri, Configuration configuration) throws IOException {
        super.initialize(uri, configuration);
        this.useEmrFileSystemStatistics();
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.checkNotStagingDirectoryPath(path);
        Path absolutePath = this.makeAbsolute(path);
        String key = S3UriUtils.pathToKey(absolutePath);
        if (key.length() != 0) {
            Path parent = absolutePath.getParent();
            if (!this.exists(parent)) {
                throw new FileNotFoundException(String.format("Unable to create '%s': parent '%s' was not found.", absolutePath, parent));
            }
            if (!this.isDirectory(parent)) {
                throw new IOException(String.format("Unable to create '%s': parent '%s' is not a directory.", absolutePath, parent));
            }
        }
        return this.create(absolutePath, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataInputStreamBuilder openFile(Path path) {
        return new EmrFSDataInputStreamBuilder(this, path);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"*"};
        long length = file.getLen();
        long blockSize = this.getDefaultBlockSize();
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>((int)(length / blockSize + 1L));
        long i = 0L;
        while (length > 0L) {
            long blockLength;
            if ((length -= (blockLength = Math.min(blockSize, length))) < blockSize) {
                blockLength += length;
                length = 0L;
            }
            locations.add(new BlockLocation(name, host, blockSize * i, blockLength));
            logger.debug("Adding block at " + blockSize * i + " with length " + blockLength);
            ++i;
        }
        return locations.toArray(new BlockLocation[0]);
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDirectory = newDir;
    }

    public long getDefaultBlockSize() {
        return ConfigurationUtils.getBlockSize(this.getConf());
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException();
    }

    private final void useEmrFileSystemStatistics() {
        this.statistics = this.emrFileSystemStatistics;
    }

    protected String pathToKey(Path path) {
        return S3UriUtils.pathToKey(path);
    }

    protected abstract FSDataInputStream select(Path var1, Configuration var2, int var3) throws IOException;

    protected Path makeAbsolute(Path path) {
        return S3UriUtils.makeAbsolute(this.workingDirectory, path);
    }

    protected final void checkNotStagingDirectoryPath(Path path) throws IOException {
        if (this.getStagingDirectoryService().isStagingDirectoryPath(path)) {
            throw new UnsupportedStagingDirectoryOperationException(String.format("Paths under staging directories are not supported (%s)", path));
        }
    }
}

