/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.consistency.exception.ConsistencyException;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfo;
import com.amazon.ws.emr.hadoop.fs.s3.InputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3Object;
import com.amazon.ws.emr.hadoop.fs.util.MorePreconditions;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import lombok.NonNull;

public class GetObjectInputStreamWithInfoFactory
implements InputStreamWithInfoFactory {
    @NonNull
    private final AmazonS3Lite s3;
    private final String etagVerification;

    @Override
    public boolean supportsMaxLength() {
        return true;
    }

    @Override
    public InputStreamWithInfo create(@NonNull String bucket, @NonNull String key, long position, long contentLength, @Nullable Long maxLength, boolean shouldTryInitialTimeout) throws IOException {
        S3Object object;
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.checkContentLength(contentLength);
        this.checkPosition(position, contentLength);
        this.checkMaxLength(maxLength);
        if (this.shouldReturnEmptyStream(position, contentLength, maxLength)) {
            return new InputStreamWithInfo(new ByteArrayInputStream(new byte[0]), key, contentLength, (Long)0L);
        }
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucket, key);
        Long maxRequestedBytes = null;
        if (this.isRangedGetRequired(position, maxLength)) {
            long end = this.getEndInclusive(position, contentLength, maxLength);
            getObjectRequest.setRange(position, end);
            maxRequestedBytes = end - position + 1L;
        }
        if (this.etagVerification != null) {
            getObjectRequest.withMatchingETagConstraint(this.etagVerification);
        }
        if ((object = this.s3.getObject(getObjectRequest, shouldTryInitialTimeout)) == null) {
            String errorMessage = String.format("eTag in metadata for File '%s/%s' does not match eTag from S3!", bucket, key);
            throw new ConsistencyException(errorMessage, Collections.singletonList(S3UriUtils.getPathForS3Object(bucket, key)));
        }
        return new InputStreamWithInfo(object.getObjectContent(), key, contentLength, maxRequestedBytes);
    }

    private void checkMaxLength(@Nullable Long maxLength) {
        if (maxLength != null) {
            MorePreconditions.checkNotNegative(maxLength, "max length");
        }
    }

    @Override
    public InputStreamWithInfo createClosedStream(String bucket, String key, long contentLength) throws IOException {
        return new InputStreamWithInfo(key, contentLength);
    }

    private void checkContentLength(long contentLength) {
        MorePreconditions.checkNotNegative(contentLength, "content length");
    }

    private void checkPosition(long position, long contentLength) throws EOFException {
        MorePreconditions.checkNotNegative(position, "position");
        if (position > contentLength) {
            throw new EOFException(String.format("Invalid position: %d, exceeds the bounds of the stream: [0, %d]", position, contentLength));
        }
    }

    private boolean shouldReturnEmptyStream(long position, long contentLength, @Nullable Long maxLength) {
        return position == contentLength || maxLength != null && maxLength == 0L;
    }

    private boolean isRangedGetRequired(long position, @Nullable Long maxLength) {
        return position > 0L || maxLength != null;
    }

    private long getEndInclusive(long position, long contentLength, @Nullable Long maxLength) {
        long contentEnd = contentLength - 1L;
        if (maxLength != null) {
            long availableLength = contentLength - position;
            return maxLength < availableLength ? Math.addExact(position, maxLength - 1L) : contentEnd;
        }
        return contentEnd;
    }

    GetObjectInputStreamWithInfoFactory(@NonNull AmazonS3Lite s3, String etagVerification) {
        if (s3 == null) {
            throw new NullPointerException("s3 is marked non-null but is null");
        }
        this.s3 = s3;
        this.etagVerification = etagVerification;
    }

    public static GetObjectInputStreamWithInfoFactoryBuilder builder() {
        return new GetObjectInputStreamWithInfoFactoryBuilder();
    }

    public static class GetObjectInputStreamWithInfoFactoryBuilder {
        private AmazonS3Lite s3;
        private String etagVerification;

        GetObjectInputStreamWithInfoFactoryBuilder() {
        }

        public GetObjectInputStreamWithInfoFactoryBuilder s3(@NonNull AmazonS3Lite s3) {
            if (s3 == null) {
                throw new NullPointerException("s3 is marked non-null but is null");
            }
            this.s3 = s3;
            return this;
        }

        public GetObjectInputStreamWithInfoFactoryBuilder etagVerification(String etagVerification) {
            this.etagVerification = etagVerification;
            return this;
        }

        public GetObjectInputStreamWithInfoFactory build() {
            return new GetObjectInputStreamWithInfoFactory(this.s3, this.etagVerification);
        }

        public String toString() {
            return "GetObjectInputStreamWithInfoFactory.GetObjectInputStreamWithInfoFactoryBuilder(s3=" + this.s3 + ", etagVerification=" + this.etagVerification + ")";
        }
    }
}

