/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystem;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.DefaultMultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.DefaultSinglePartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.StagingAwareUploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanTemplate;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.staging.DefaultStagingMechanism;
import com.amazon.ws.emr.hadoop.fs.staging.ExternalStagedFileCommitter;
import com.amazon.ws.emr.hadoop.fs.staging.StagingMechanism;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStore;
import com.amazon.ws.emr.hadoop.fs.staging.metadata.StagingMetadataStoreFactory;
import com.amazon.ws.emr.hadoop.fs.staging.path.StagingPathConverter;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import com.amazon.ws.emr.hadoop.fs.util.io.IOConsumer;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class FileCreationSubsystemFactory {
    @NonNull
    private final URI uri;
    @NonNull
    private final Configuration conf;
    @NonNull
    private final AmazonS3Lite s3;
    @NonNull
    private final S3ObjectRequestFactory requestFactory;
    @NonNull
    private final UploadObserver uploadObserver;
    @NonNull
    private final UploadPlannerFactory nonStagingPlannerFactory;
    @NonNull
    private final UnaryOperator<Path> pathQualifier;
    @NonNull
    private final Consumer<Path> pathChecker;
    @NonNull
    private final IOConsumer<Path> pathDeleter;
    @NonNull
    private final FileStatusFactory fileStatusFactory;
    @NonNull
    private final ListeningExecutorService exec;
    @NonNull
    private final StagingPathConverter stagingPathConverter;
    @NonNull
    private final StagingMetadataStoreFactory stagingMetadataStoreFactory;

    public FileCreationSubsystem create() {
        UploadPlanTemplate planTemplate = this.newUploadPlanTemplate();
        return this.newFileCreationSubsystem(planTemplate);
    }

    private UploadPlanTemplate newUploadPlanTemplate() {
        return UploadPlanTemplate.builder().bucket(S3UriUtils.uriToBucket(this.uri)).configuration(this.conf).singlePartDispatcher(this.newSinglePartDispatcher()).multipartDispatcher(this.newMultipartDispatcher()).build();
    }

    private DefaultSinglePartUploadDispatcher newSinglePartDispatcher() {
        return new DefaultSinglePartUploadDispatcher(this.s3, this.requestFactory, this.uploadObserver);
    }

    private DefaultMultipartUploadDispatcher newMultipartDispatcher() {
        return new DefaultMultipartUploadDispatcher(this.s3, this.uploadObserver);
    }

    private FileCreationSubsystem newFileCreationSubsystem(UploadPlanTemplate template) {
        StagingMetadataStore store = this.newStagingMetadataStore(template);
        StagingMechanism stagingMechanism = this.newStagingMechanism(template, store);
        UploadPlanner planner = this.newUploadPlanner(template, store);
        return new FileCreationSubsystem(stagingMechanism, planner);
    }

    private StagingMetadataStore newStagingMetadataStore(UploadPlanTemplate template) {
        return this.stagingMetadataStoreFactory.create(this.uri, template.getMultipartDispatcher());
    }

    private StagingMechanism newStagingMechanism(UploadPlanTemplate template, StagingMetadataStore store) {
        return DefaultStagingMechanism.builder().pathConverter(this.stagingPathConverter).store(store).pathQualifier(this.pathQualifier).fileStatusFactory(this.fileStatusFactory).supportsExporting(this.stagingDirectoryServiceSupportsExporting()).externalStagedFileCommitter(this.newExternalStagedFileCommitter(template)).build();
    }

    private ExternalStagedFileCommitter newExternalStagedFileCommitter(UploadPlanTemplate template) {
        return ExternalStagedFileCommitter.builder().pathChecker(this.pathChecker).pathDeleter(this.pathDeleter).uploadDispatcher(template.getMultipartDispatcher()).exec(this.exec).maxActiveTasks(ConfigurationUtils.getExternalStagedFilesMaxActiveTasks(this.conf)).build();
    }

    private boolean stagingDirectoryServiceSupportsExporting() {
        return !ConfigurationUtils.isClientSideEncryptionEnabled(this.conf) || ConfigurationUtils.getCryptoStorageMode(this.conf).equals((Object)CryptoStorageMode.ObjectMetadata);
    }

    private UploadPlanner newUploadPlanner(UploadPlanTemplate template, StagingMetadataStore store) {
        UploadPlannerFactory factory = this.newStagingAwareUploadPlannerFactory(store);
        return factory.create(template);
    }

    private UploadPlannerFactory newStagingAwareUploadPlannerFactory(StagingMetadataStore store) {
        return new StagingAwareUploadPlannerFactory(this.stagingPathConverter, store, this.nonStagingPlannerFactory);
    }

    private static StagingPathConverter $default$stagingPathConverter() {
        return StagingPathConverter.defaultConverter();
    }

    private static StagingMetadataStoreFactory $default$stagingMetadataStoreFactory() {
        return StagingMetadataStoreFactory.defaultFactory();
    }

    FileCreationSubsystemFactory(@NonNull URI uri, @NonNull Configuration conf, @NonNull AmazonS3Lite s3, @NonNull S3ObjectRequestFactory requestFactory, @NonNull UploadObserver uploadObserver, @NonNull UploadPlannerFactory nonStagingPlannerFactory, @NonNull UnaryOperator<Path> pathQualifier, @NonNull Consumer<Path> pathChecker, @NonNull IOConsumer<Path> pathDeleter, @NonNull FileStatusFactory fileStatusFactory, @NonNull ListeningExecutorService exec, @NonNull StagingPathConverter stagingPathConverter, @NonNull StagingMetadataStoreFactory stagingMetadataStoreFactory) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        if (s3 == null) {
            throw new NullPointerException("s3 is marked non-null but is null");
        }
        if (requestFactory == null) {
            throw new NullPointerException("requestFactory is marked non-null but is null");
        }
        if (uploadObserver == null) {
            throw new NullPointerException("uploadObserver is marked non-null but is null");
        }
        if (nonStagingPlannerFactory == null) {
            throw new NullPointerException("nonStagingPlannerFactory is marked non-null but is null");
        }
        if (pathQualifier == null) {
            throw new NullPointerException("pathQualifier is marked non-null but is null");
        }
        if (pathChecker == null) {
            throw new NullPointerException("pathChecker is marked non-null but is null");
        }
        if (pathDeleter == null) {
            throw new NullPointerException("pathDeleter is marked non-null but is null");
        }
        if (fileStatusFactory == null) {
            throw new NullPointerException("fileStatusFactory is marked non-null but is null");
        }
        if (exec == null) {
            throw new NullPointerException("exec is marked non-null but is null");
        }
        if (stagingPathConverter == null) {
            throw new NullPointerException("stagingPathConverter is marked non-null but is null");
        }
        if (stagingMetadataStoreFactory == null) {
            throw new NullPointerException("stagingMetadataStoreFactory is marked non-null but is null");
        }
        this.uri = uri;
        this.conf = conf;
        this.s3 = s3;
        this.requestFactory = requestFactory;
        this.uploadObserver = uploadObserver;
        this.nonStagingPlannerFactory = nonStagingPlannerFactory;
        this.pathQualifier = pathQualifier;
        this.pathChecker = pathChecker;
        this.pathDeleter = pathDeleter;
        this.fileStatusFactory = fileStatusFactory;
        this.exec = exec;
        this.stagingPathConverter = stagingPathConverter;
        this.stagingMetadataStoreFactory = stagingMetadataStoreFactory;
    }

    public static FileCreationSubsystemFactoryBuilder builder() {
        return new FileCreationSubsystemFactoryBuilder();
    }

    public static class FileCreationSubsystemFactoryBuilder {
        private URI uri;
        private Configuration conf;
        private AmazonS3Lite s3;
        private S3ObjectRequestFactory requestFactory;
        private UploadObserver uploadObserver;
        private UploadPlannerFactory nonStagingPlannerFactory;
        private UnaryOperator<Path> pathQualifier;
        private Consumer<Path> pathChecker;
        private IOConsumer<Path> pathDeleter;
        private FileStatusFactory fileStatusFactory;
        private ListeningExecutorService exec;
        private boolean stagingPathConverter$set;
        private StagingPathConverter stagingPathConverter$value;
        private boolean stagingMetadataStoreFactory$set;
        private StagingMetadataStoreFactory stagingMetadataStoreFactory$value;

        FileCreationSubsystemFactoryBuilder() {
        }

        public FileCreationSubsystemFactoryBuilder uri(@NonNull URI uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            this.uri = uri;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder conf(@NonNull Configuration conf) {
            if (conf == null) {
                throw new NullPointerException("conf is marked non-null but is null");
            }
            this.conf = conf;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder s3(@NonNull AmazonS3Lite s3) {
            if (s3 == null) {
                throw new NullPointerException("s3 is marked non-null but is null");
            }
            this.s3 = s3;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder requestFactory(@NonNull S3ObjectRequestFactory requestFactory) {
            if (requestFactory == null) {
                throw new NullPointerException("requestFactory is marked non-null but is null");
            }
            this.requestFactory = requestFactory;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder uploadObserver(@NonNull UploadObserver uploadObserver) {
            if (uploadObserver == null) {
                throw new NullPointerException("uploadObserver is marked non-null but is null");
            }
            this.uploadObserver = uploadObserver;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder nonStagingPlannerFactory(@NonNull UploadPlannerFactory nonStagingPlannerFactory) {
            if (nonStagingPlannerFactory == null) {
                throw new NullPointerException("nonStagingPlannerFactory is marked non-null but is null");
            }
            this.nonStagingPlannerFactory = nonStagingPlannerFactory;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder pathQualifier(@NonNull UnaryOperator<Path> pathQualifier) {
            if (pathQualifier == null) {
                throw new NullPointerException("pathQualifier is marked non-null but is null");
            }
            this.pathQualifier = pathQualifier;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder pathChecker(@NonNull Consumer<Path> pathChecker) {
            if (pathChecker == null) {
                throw new NullPointerException("pathChecker is marked non-null but is null");
            }
            this.pathChecker = pathChecker;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder pathDeleter(@NonNull IOConsumer<Path> pathDeleter) {
            if (pathDeleter == null) {
                throw new NullPointerException("pathDeleter is marked non-null but is null");
            }
            this.pathDeleter = pathDeleter;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder fileStatusFactory(@NonNull FileStatusFactory fileStatusFactory) {
            if (fileStatusFactory == null) {
                throw new NullPointerException("fileStatusFactory is marked non-null but is null");
            }
            this.fileStatusFactory = fileStatusFactory;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder exec(@NonNull ListeningExecutorService exec) {
            if (exec == null) {
                throw new NullPointerException("exec is marked non-null but is null");
            }
            this.exec = exec;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder stagingPathConverter(@NonNull StagingPathConverter stagingPathConverter) {
            if (stagingPathConverter == null) {
                throw new NullPointerException("stagingPathConverter is marked non-null but is null");
            }
            this.stagingPathConverter$value = stagingPathConverter;
            this.stagingPathConverter$set = true;
            return this;
        }

        public FileCreationSubsystemFactoryBuilder stagingMetadataStoreFactory(@NonNull StagingMetadataStoreFactory stagingMetadataStoreFactory) {
            if (stagingMetadataStoreFactory == null) {
                throw new NullPointerException("stagingMetadataStoreFactory is marked non-null but is null");
            }
            this.stagingMetadataStoreFactory$value = stagingMetadataStoreFactory;
            this.stagingMetadataStoreFactory$set = true;
            return this;
        }

        public FileCreationSubsystemFactory build() {
            StagingPathConverter stagingPathConverter$value = this.stagingPathConverter$value;
            if (!this.stagingPathConverter$set) {
                stagingPathConverter$value = FileCreationSubsystemFactory.$default$stagingPathConverter();
            }
            StagingMetadataStoreFactory stagingMetadataStoreFactory$value = this.stagingMetadataStoreFactory$value;
            if (!this.stagingMetadataStoreFactory$set) {
                stagingMetadataStoreFactory$value = FileCreationSubsystemFactory.$default$stagingMetadataStoreFactory();
            }
            return new FileCreationSubsystemFactory(this.uri, this.conf, this.s3, this.requestFactory, this.uploadObserver, this.nonStagingPlannerFactory, this.pathQualifier, this.pathChecker, this.pathDeleter, this.fileStatusFactory, this.exec, stagingPathConverter$value, stagingMetadataStoreFactory$value);
        }

        public String toString() {
            return "FileCreationSubsystemFactory.FileCreationSubsystemFactoryBuilder(uri=" + this.uri + ", conf=" + this.conf + ", s3=" + this.s3 + ", requestFactory=" + this.requestFactory + ", uploadObserver=" + this.uploadObserver + ", nonStagingPlannerFactory=" + this.nonStagingPlannerFactory + ", pathQualifier=" + this.pathQualifier + ", pathChecker=" + this.pathChecker + ", pathDeleter=" + this.pathDeleter + ", fileStatusFactory=" + this.fileStatusFactory + ", exec=" + this.exec + ", stagingPathConverter$value=" + this.stagingPathConverter$value + ", stagingMetadataStoreFactory$value=" + this.stagingMetadataStoreFactory$value + ")";
        }
    }
}

