/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.s3.DestinationObjectMetadataFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;

class DefaultDestinationObjectMetadataFactory
implements DestinationObjectMetadataFactory {
    private final String serverSideEncryptionAlgorithm;
    private final String serverSideEncryptionKmsKeyId;

    @Override
    public ObjectMetadata createFromSource(ObjectMetadata source) {
        return new CreateSession(source).create();
    }

    private static boolean isKmsAlgorithm(String serverSideEncryptionAlgorithm) {
        return serverSideEncryptionAlgorithm != null && serverSideEncryptionAlgorithm.equalsIgnoreCase(SSEAlgorithm.KMS.getAlgorithm());
    }

    public DefaultDestinationObjectMetadataFactory(String serverSideEncryptionAlgorithm, String serverSideEncryptionKmsKeyId) {
        this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
        this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
    }

    private final class CreateSession {
        private final ObjectMetadata source;
        private final ObjectMetadata result = new ObjectMetadata();

        private ObjectMetadata create() {
            this.setContentTypeIfAvailable();
            this.setContentEncodingIfAvailable();
            this.setUserMetadataIfAvailable();
            this.setSseHeadersIfAvailable();
            return this.result;
        }

        private void setContentTypeIfAvailable() {
            if (this.source.getContentType() != null) {
                this.result.setContentType(this.source.getContentType());
            }
        }

        private void setContentEncodingIfAvailable() {
            if (this.source.getContentEncoding() != null) {
                this.result.setContentEncoding(this.source.getContentEncoding());
            }
        }

        private void setUserMetadataIfAvailable() {
            if (this.source.getUserMetadata() != null) {
                this.result.setUserMetadata(this.source.getUserMetadata());
            }
        }

        private void setSseHeadersIfAvailable() {
            if (this.isConfiguredWithSseAlgorithm()) {
                this.setSseHeadersFromConfiguration();
            } else if (this.doesSourceHaveSseHeaders()) {
                this.setSseHeadersFromSource();
            }
        }

        private boolean isConfiguredWithSseAlgorithm() {
            return !Strings.isNullOrEmpty(DefaultDestinationObjectMetadataFactory.this.serverSideEncryptionAlgorithm);
        }

        private void setSseHeadersFromConfiguration() {
            this.setSseHeaders(DefaultDestinationObjectMetadataFactory.this.serverSideEncryptionAlgorithm, DefaultDestinationObjectMetadataFactory.this.serverSideEncryptionKmsKeyId);
        }

        private boolean doesSourceHaveSseHeaders() {
            return this.source.getSSEAlgorithm() != null;
        }

        private void setSseHeadersFromSource() {
            this.setSseHeaders(this.source.getSSEAlgorithm(), this.source.getSSEAwsKmsKeyId());
        }

        private void setSseHeaders(String algorithm, String kmsKeyId) {
            this.result.setSSEAlgorithm(algorithm);
            if (DefaultDestinationObjectMetadataFactory.isKmsAlgorithm(algorithm) && kmsKeyId != null) {
                this.result.setHeader("x-amz-server-side-encryption-aws-kms-key-id", kmsKeyId);
            }
        }

        public CreateSession(ObjectMetadata source) {
            this.source = source;
        }
    }
}

