/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.s3;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.IOUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import lombok.NonNull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.util.ByteBufferIOUtils;

@InterfaceAudience.Private
public abstract class AbstractS3FSInputStream
extends FSInputStream {
    private static final int COPY_BUFFER_SIZE_IN_BYTE = 8192;
    @NonNull
    private final String bucket;
    @NonNull
    private final String key;
    private final boolean optimizePositionedRead;
    private final boolean optimizeReadFullyIntoBuffers;
    private byte[] copyBuffer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (!this.optimizePositionedRead) {
            return super.read(position, buffer, offset, length);
        }
        this.validatePositionedReadArgs(position, buffer, offset, length);
        Preconditions.checkPositionIndex(offset, buffer.length, "offset");
        if (length == 0) {
            return 0;
        }
        try (InputStream input = this.forkStream(position, length);){
            int bytesRead = IOUtils.read(input, buffer, offset, length);
            int n = bytesRead > 0 ? bytesRead : -1;
            return n;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        if (!this.optimizePositionedRead) {
            super.readFully(position, buffer, offset, length);
        } else {
            int bytesRead = this.read(position, buffer, offset, length);
            if (bytesRead != length) {
                throw new EOFException("End of file reached before reading fully.: bucket=" + this.bucket + ", key=" + this.key + ", position=" + position + ", request length=" + length);
            }
        }
    }

    public void readFullyIntoBuffers(long position, List<ByteBuffer> byteBuffers) throws IOException {
        if (!this.optimizeReadFullyIntoBuffers) {
            super.readFullyIntoBuffers(position, byteBuffers);
            return;
        }
        ByteBufferIOUtils.validateReadIntoBuffers((long)position, byteBuffers);
        long length = 0L;
        for (ByteBuffer byteBuffer : byteBuffers) {
            length += (long)byteBuffer.remaining();
        }
        long seekPositionAfterRead = Math.addExact(position, length);
        try (InputStream input = this.forkStream(position, length);){
            for (ByteBuffer buffer : byteBuffers) {
                ByteBufferIOUtils.readFully((InputStream)input, (ByteBuffer)buffer, (byte[])this.getCopyBuffer());
            }
        }
        this.seek(seekPositionAfterRead);
    }

    protected abstract InputStream forkStream(long var1, long var3) throws IOException;

    private byte[] getCopyBuffer() {
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[8192];
        }
        return this.copyBuffer;
    }

    protected AbstractS3FSInputStream(@NonNull String bucket, @NonNull String key, boolean optimizePositionedRead, boolean optimizeReadFullyIntoBuffers) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.bucket = bucket;
        this.key = key;
        this.optimizePositionedRead = optimizePositionedRead;
        this.optimizeReadFullyIntoBuffers = optimizeReadFullyIntoBuffers;
    }
}

