/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMapping;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingBuilder;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UserRoleMapping
extends RoleMapping {
    private static final Logger logger = LoggerFactory.getLogger(UserRoleMapping.class);
    private final String[] usernames;

    UserRoleMapping(String roleArn, String[] usernames) {
        super(roleArn);
        this.usernames = usernames;
    }

    static UserRoleMappingBuilder builder() {
        return new UserRoleMappingBuilder();
    }

    @Override
    boolean appliesTo(RoleMappingContext context) {
        FileSystemOwner fileSystemOwner = context.getFileSystemOwner();
        if (fileSystemOwner == null) {
            return false;
        }
        for (String user : this.getTargets()) {
            if (!user.equals(fileSystemOwner.getShortUserName())) continue;
            logger.debug("Matching {} : {} with {}", new Object[]{this, user, fileSystemOwner});
            return true;
        }
        return false;
    }

    @Override
    String[] getTargets() {
        return this.usernames;
    }

    @Override
    RoleMappingType getType() {
        return RoleMappingType.USER;
    }

    static class UserRoleMappingBuilder
    extends RoleMappingBuilder {
        @Override
        UserRoleMapping build() {
            return new UserRoleMapping(this.getRoleArn(), this.getTargets());
        }

        private UserRoleMappingBuilder() {
        }
    }
}

