/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMapping;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Resource;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoleMappings {
    private static final Logger logger = LoggerFactory.getLogger(RoleMappings.class);
    private static final List<RoleMapping> ROLE_MAPPINGS = RoleMappings.initializeMappingsFromConfiguration(new Configuration());

    @VisibleForTesting
    static List<RoleMapping> initializeMappingsFromConfiguration(Configuration conf) {
        String[] stringMappings = conf.getTrimmedStrings("fs.s3.authorization.roleMapping");
        ArrayList<RoleMapping> roleMappingList = new ArrayList<RoleMapping>();
        for (String mapping : stringMappings) {
            try {
                RoleMapping newMapping = RoleMapping.fromConfig(mapping);
                Preconditions.checkNotNull(newMapping);
                roleMappingList.add(newMapping);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warn("Failure to parse role mapping: {}", (Throwable)e);
            }
        }
        return roleMappingList;
    }

    @VisibleForTesting
    static void setRoleMappings(List<RoleMapping> roleMappings) {
        ROLE_MAPPINGS.clear();
        ROLE_MAPPINGS.addAll(roleMappings);
    }

    @Nullable
    public static String getRoleArnForContext(RoleMappingContext context) {
        return RoleMappings.getRoleArnForGeneric(rm -> rm.appliesTo(context));
    }

    @Nullable
    public static String getRoleArnForFileSystemOwner(FileSystemOwner fileSystemOwner) {
        return RoleMappings.getRoleArnForGeneric(rm -> rm.appliesTo(RoleMappingContext.builder().withFileSystemOwner(fileSystemOwner).build()));
    }

    @Nullable
    public static String getRoleArnForS3Resources(Collection<S3Resource> resources) {
        return RoleMappings.getRoleArnForGeneric(rm -> rm.appliesTo(RoleMappingContext.builder().withS3Resources(resources).build()));
    }

    private static String getRoleArnForGeneric(Function<RoleMapping, Boolean> curriedAppliesTo) {
        for (RoleMapping roleMapping : ROLE_MAPPINGS) {
            if (!curriedAppliesTo.apply(roleMapping).booleanValue()) continue;
            return roleMapping.getRoleArn();
        }
        return null;
    }
}

